<?php

namespace Application\Core\Form\Field;

use Application\Core\Model\Language;
use Application\Core\Model\LanguageSite;
use Application\Core\Model\Site;
use Pongho\Form\Field\SelectField;

class LanguageSiteField extends SelectField
{
    /**
     * Imposta le opzioni della select
     *
     * @access public
     * @throws \BadMethodCallException
     */
    public function setOptions($options)
    {
        throw new \BadMethodCallException('You could\'t override the regions!');
    }

    /**
     * Restituisce le opzioni della select
     *
     * @access public
     * @return array
     */
    public function getOptions()
    {
        if ( empty($this->options) )
        {
            $languages = array();
            foreach (Language::all() as $language) {
                $languages[$language->id] = $language;
            }

            $sites = array();
            foreach (Site::all() as $site) {
                $sites[$site->id] = $site;
            }

            foreach (LanguageSite::all() as $language_site) {
                $label = (isset($sites[$language_site->site_id]) ? $sites[$language_site->site_id]->name : '') . ' - ' . (isset($languages[$language_site->language_id]) ? $languages[$language_site->language_id]->name : '');
                $this->options[$language_site->id] = $label;
            }
        }

        return $this->options;
    }
}
