<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Export\Serializer;

use Application\Core\Export\DataExporterInterface;
use Application\Core\Export\SerializerInterface;
use Pongho\Http\CallableResponse;

/**
 * CsvSerializer
 */
class CsvSerializer implements SerializerInterface
{
    /**
     * @var string
     */
    private $delimiter = ',';

    /**
     * @var string
     */
    private $enclosure = '"';

    /**
     * {@inheritdoc}
     */
    public function serialize(DataExporterInterface $exporter)
    {
        return new CallableResponse(function () use ($exporter) {
            $csv = fopen('php://output', 'w');

            fputcsv($csv, $exporter->headers(), $this->delimiter, $this->enclosure);

            foreach ($exporter->export() as $row) {
                fputcsv($csv, $row, $this->delimiter, $this->enclosure);
            }
        });
    }

    /**
     * {@inheritdoc}
     */
    public function getFileExtension()
    {
        return 'csv';
    }

    /**
     * @param string $delimiter
     * @param string $enclosure
     * @return $this
     */
    public function setCsvControl($delimiter = ',', $enclosure = '"')
    {
        $this->delimiter = $delimiter;
        $this->enclosure = $enclosure;

        return $this;
    }
}
