<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Entity;

/**
 * Interface SiteInterface
 */
interface SiteInterface extends SettingsInterface
{
    /**
     * Restituisce l'id del sito
     *
     * @return integer
     */
    public function getId();

    /**
     * @return int
     */
    public function getDefaultLanguageId();

    /**
     * Restituisce il nome del sito.
     *
     * @return string
     */
    public function getName();

    /**
     * Restituisce il link alla home page del sito.
     *
     * Esempi:
     * - `http://www.example.com`
     * - `http://www.example.com/site`
     *
     * @return string
     */
    public function getPermalink();

    /**
     * Restituisce il dominio del sito.
     *
     * Esempi:
     * - `http://www.example.com/`
     * - `http://www.example.com/site/`
     *
     * @return string
     */
    public function getDomain();

    /**
     * @return \Application\Core\Entity\LanguageSiteInterface
     */
    public function getDefaultLanguage();

    /**
     * Restituisce il percorso della cartella `content`.
     *
     * @param string $path
     * @return string
     */
    public function getContentPath($path = '');

    /**
     * Restituisce il percorso del tema.
     *
     * @param string $path
     * @return string
     */
    public function getThemesPath($path = '');

    /**
     * Restituisce il percorso delle immagini.
     *
     * @param string $path
     * @return string
     */
    public function getImagesPath($path = '');

    /**
     * Restituisce il percorso di caricamento dei file.
     *
     * @param string $path
     * @return string
     */
    public function getUploadsPath($path = '');

    /**
     * Restituisce l'url della cartella delle immagini.
     *
     * @param string $path
     * @return string
     */
    public function getImagesUrl($path = '');

    /**
     * Restituisce l'url della cartella degli upload
     *
     * @param string $path
     * @return string
     */
    public function getUploadsUrl($path = '');

    /**
     * Restituisce l'url della cartella del tema
     *
     * @param string $path
     * @return string
     */
    public function getThemesUrl($path = '');
}
