<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Entity;

/**
 * Interface ModuleSiteInterface
 */
interface ModuleSiteInterface extends SettingsInterface
{
    /**
     * @return int
     */
    public function getId();

    /**
     * @return int
     */
    public function getModuleId();

    /**
     * @return ModuleInterface
     */
    public function getModule();

    /**
     * @return int
     */
    public function getSiteId();

    /**
     * @return SiteInterface
     */
    public function getSite();

    /**
     * @return bool
     */
    public function isEnabled();

    /**
     * @return LanguageModuleInterface[]
     */
    public function getLanguageModules();

    /**
     * @param int|LanguageInterface $language
     * @return LanguageModuleInterface
     */
    public function getLanguageModule($language = null);

    /**
     * @param int|LanguageInterface $language
     * @return string
     */
    public function getName($language = null);

    /**
     * @param int|LanguageInterface $language
     * @return string
     */
    public function getPermalink($language = null);
}
