<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Sdk\GoogleAnalytics\MeasurementProtocol\Client\GuzzleClient;
use Pongho\Sdk\GoogleAnalytics\MeasurementProtocol\MeasurementProtocol;

/**
 * SdkServiceProvider
 */
class SdkServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->share('sdk.google_analytics_measurement_protocol', array($this, 'getGoogleAnalyticsMeasurementProtocol'));
    }

    /**
     * @param Container $container
     * @return MeasurementProtocol
     */
    public function getGoogleAnalyticsMeasurementProtocol(Container $container)
    {
        /** @var \Application\Core\Model\Site $site */
        $site = $container->get('site');

        /** @var \Pongho\Http\Request $request */
        $request = $container->get('request');

        return new MeasurementProtocol(
            $site->getOption('google_analytics'),
            new GuzzleClient($request->headers->get('User-Agent'))
        );
    }
}
