<?php

/**
 * Questo file è parte di Pongho (Dev).
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\Routes\ApiRoute;
use Application\Core\Routes\ImagesRoute;
use Application\Core\Routes\ModulesRoute;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Routing\RoutesCollection;

/**
 * RoutingServiceProvider
 */
class RoutingServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->extend(
            'routes_collection',
            function (RoutesCollection $collection) {
                if (!$collection->has('api')) {
                    $collection->add('api', new ApiRoute('/api/{app}/{command}'), -100);
                }

                if (!$collection->has('images')) {
                    $collection->add('images', new ImagesRoute(), -100);
                }

                if (!$collection->has('modules')) {
                    $collection->add('modules', new ModulesRoute(), 100);
                }
            }
        );
    }
}
