<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Admin\Widget\Stats\Collection;
use Application\Core\Dashboard\Widget\UserStats;
use Application\Core\Model\Account;
use Application\Core\Model\Role;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

/**
 * DashboardServiceProvider
 */
class DashboardServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->share('admin_dashboard_stats_users', array($this, 'getStatsUsers'));

        $container->extend(
            'admin_dashboard_stats_collection',
            function (Collection $collection, Container $container) {
                $collection->add($container->get('admin_dashboard_stats_users'));
            }
        );
    }

    /**
     * @param Container $container
     * @return UserStats
     *
     * @internal
     */
    public function getStatsUsers(Container $container)
    {
        $stats = new UserStats($container->get('translator'));

        $options = array(
            'select'     => '`from`.name, COUNT(a.id) AS accounts',
            'joins'      => 'INNER JOIN ' . Account::tableName() . ' AS a ON a.role_id = `from`.id',
            'conditions' => array('`from`.id <> :role', 'role' => Role::USER_NOT_LOGGED),
            'group'      => '`from`.id',
        );

        /** @var Role $role */
        foreach (Role::all($options) as $role) {
            $stats->addValue($role->name, $role->accounts);
        }

        return $stats;
    }
}
