<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\CommandBus\Command\User\Login\LoginCommand;
use Application\Core\CommandBus\Command\User\Login\LoginHandler;
use Application\Core\CommandBus\ContainerLocator;
use League\Tactician\CommandBus;
use League\Tactician\Handler\CommandHandlerMiddleware;
use League\Tactician\Handler\CommandNameExtractor\ClassNameExtractor;
use League\Tactician\Handler\MethodNameInflector\HandleInflector;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

/**
 * CommandBusServiceProvider
 */
class CommandBusServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->set('command_bus', function (Container $container) {
            return new CommandBus(
                $container->get('command_bus.middleware')
            );
        });

        $container->set('command_bus.middleware', function (Container $container) {
            return [
                new CommandHandlerMiddleware(
                    $container->get('command_bus.command_name_extractor'),
                    $container->get('command_bus.handler_locator'),
                    $container->get('command_bus.method_name_inflector')
                ),
            ];
        });

        $container->set('command_bus.command_name_extractor', function () {
            return new ClassNameExtractor();
        });

        $container->set('command_bus.handler_locator', function (Container $container) {
            return new ContainerLocator($container);
        });

        $container->set('command_bus.method_name_inflector', function () {
            return new HandleInflector();
        });

        $this->registerHandlers($container);
    }

    private function registerHandlers(Container $container)
    {
        $container->share(ContainerLocator::SERVICE_PREFIX . LoginCommand::class, function () {
            return new LoginHandler();
        });
    }
}
