<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\Console\Command\CacheClearCommand;
use Pongho\Caching\FileCache;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class CachingServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->share('cache', array($this, 'getCacheService'));

        $container->extend(
            'console_commands',
            function (\ArrayObject $commands, Container $container) {
                $commands->append(new CacheClearCommand($container->get('cache')));
            }
        );
    }

    /**
     * Restituisce il gestore della cache.
     *
     * @return \Pongho\Caching\AbstractCache
     *
     * @internal
     */
    public function getCacheService()
    {
        return new FileCache('pongho', CACHE_PATH);
    }
}
