<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Dashboard\Widget;

use Application\Admin\Widget\Stats\StatInterface;
use Application\Core\I18n\Translation\Translator;

/**
 * UserStats
 */
class UserStats implements StatInterface
{
    /**
     * @var array
     */
    protected $values = array();

    /**
     * @var Translator
     */
    protected $translator;

    /**
     * @param Translator $translator
     */
    public function __construct(Translator $translator)
    {
        $this->translator = $translator;
    }

    /**
     * @param string $label
     * @param int    $amount
     * @return $this
     */
    public function addValue($label, $amount)
    {
        $this->values[$label] = (int) $amount;

        return $this;
    }

    /**
     * @param string $label
     * @return $this
     */
    public function removeValue($label)
    {
        unset($this->values[$label]);

        return $this;
    }

    /**
     * @return $this
     */
    public function resetValues()
    {
        $this->values = array();

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function render()
    {
        return <<<HTML
<div id="statsreport-users" class="statsreport-table">
	<h4>{$this->translator->trans('Users')}</h4>
	<table>
		<tr>
			<th>{$this->translator->trans('Role')}</th>
			<th class="statsreport-count">{$this->translator->trans('Count')}</th>
		</tr>

		{$this->renderRows()}

	</table>
</div>
HTML;
    }

    /**
     * @return string
     */
    protected function renderRows()
    {
        $rows = '';
        foreach ($this->values as $label => $amount) {
            $rows .= "<tr><td>{$label}</td><td>{$amount}</td></tr>";
        }

        return $rows;
    }
}
