<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Cron;

/**
 * Task
 */
class Task implements \JsonSerializable
{
    /**
     * @var int
     */
    protected $id;

    /**
     * @var string
     */
    protected $service_name;

    /**
     * @var string|array
     */
    protected $data;

    /**
     * @var \DateTime
     */
    protected $created_at;

    /**
     * @var int
     */
    protected $attempts;

    /**
     * @var \DateTime
     */
    protected $last_attempt_at;

    /**
     * @var \DateTime
     */
    protected $executed_at;

    /**
     * @return string
     */
    public function getServiceName()
    {
        return $this->service_name;
    }

    /**
     * @return array|string
     */
    public function getData()
    {
        if (!is_array($this->data)) {
            $this->data = json_decode($this->data, true);
        }

        return $this->data;
    }

    /**
     * @return int
     */
    public function getAttempts()
    {
        return $this->attempts;
    }

    /**
     * @return $this
     */
    public function attempt()
    {
        $this->attempts++;
        $this->last_attempt_at = new \DateTime();

        return $this;
    }

    /**
     * @return $this
     */
    public function executed()
    {
        $this->executed_at = new \DateTime();

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function jsonSerialize()
    {
        return [
            'id'              => $this->id,
            'service_name'    => $this->service_name,
            'data'            => $this->data,
            'created_at'      => $this->created_at,
            'attempts'        => $this->attempts,
            'last_attempt_at' => $this->last_attempt_at,
            'executed_at'     => $this->executed_at,
        ];
    }
}
