<?php

/**
 * Questo file è parte di Pongho 2.0-dev.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Controller\Admin;

use Application\Admin\Controller\SiteOptionsController;

/**
 * Class SettingsController
 */
class SettingsController extends SiteOptionsController
{
    /**
     * Tab principale
     */
    public function indexAction()
    {
        $site = $this->getHelper()->getSite();

        if ($this->getRequest()->getMethod() === 'POST' && isset($_POST['site']) && is_array($_POST['site'])) {
            $site->updateAttributes($_POST['site']);
        }

        $this->handleRequest(
            array(
                'site_name'                   => 'text',
                'site_domain'                 => 'text',
                'default_language'            => 'integer',
                'subscription_mode'           => 'text',
                'account_url'                 => 'boolean',
                'slogan'                      => 'text',
                'recaptcha'                   => 'boolean',
                'recaptcha_private_key'       => 'text',
                'recaptcha_public_key'        => 'text',
                'recaptcha2_private_key'      => 'text',
                'recaptcha2_public_key'       => 'text',
                'recaptcha2_labs_private_key' => 'text',
                'recaptcha2_labs_public_key'  => 'text',
                'google_maps_api_key'         => 'text',
            )
        );

        $this->getHelper()->getBodyView()
            ->setTemplatePath(__DIR__ . '/../../Resources/views/settings_main.php')
            ->assignVars(
                array(
                    'action_form' => $this->url('/' . $this->getParameter('path') . '/'),
                    'site'        => $site,
                )
            );

        $this->displayTabs();
    }

    /**
     * Tab company
     */
    public function companyAction()
    {
        $site = $this->getHelper()->getSite();

        if ($this->getRequest()->getMethod() === 'POST' && isset($_POST['site']) && is_array($_POST['site'])) {
            $site->updateAttributes($_POST['site']);
        }

        $this->handleRequest(
            array(
                'company_name'           => 'text',
                'company_type'           => 'text',
                'company_ceo_name'       => 'text',
                'company_address'        => 'text',
                'company_postcode'       => 'text',
                'company_city'           => 'text',
                'company_city_link'      => 'text',
                'company_province'       => 'text',
                'company_province_plate' => 'text',
                'company_country'        => 'text',
                'company_partita_iva'    => 'text',
                'company_codice_fiscale' => 'text',
                'company_rea'            => 'text',
                'company_camera'         => 'text',
                'company_cap_soc'        => 'text',
                'company_website'        => 'text',
                'company_email'          => 'text',
                'company_tel'            => 'text',
                'company_tel2'           => 'text',
                'company_tel3'           => 'text',
                'company_fax'            => 'text',
                'company_fax2'           => 'text',
                'company_fax3'           => 'text',
                'company_copyright'      => 'text',
                // Google Maps
                'company_latitude'       => 'text',
                'company_longitude'      => 'text',
            )
        );

        $this->getHelper()->getBodyView()
            ->setTemplatePath(__DIR__ . '/../../Resources/views/settings_company.php')
            ->assignVars(
                array(
                    'action_form' => $this->url('/' . $this->getParameter('path') . '/company/'),
                    'site'        => $site,
                )
            );

        $this->displayTabs();
    }

    /**
     * Tab social
     */
    public function socialAction()
    {
        $site = $this->getHelper()->getSite();

        if ($this->getRequest()->getMethod() === 'POST' && isset($_POST['site']) && is_array($_POST['site'])) {
            $site->updateAttributes($_POST['site']);
        }

        $this->handleRequest(
            array(
                'fb'           => 'boolean',
                'fb_comments'  => 'boolean',
                'fb_appid'     => 'text',
                'fb_appsecret' => 'text',
                'fb_admin_id'  => 'text',
                'fb_og_type'   => 'text',
            )
        );

        $this->getHelper()->getBodyView()
            ->setTemplatePath(__DIR__ . '/../../Resources/views/settings_social.php')
            ->assignVars(
                array(
                    'action_form' => $this->url('/' . $this->getParameter('path') . '/social/'),
                    'site'        => $site,
                )
            );

        $this->displayTabs();
    }

    /**
     * Tab dashboard
     */
    public function dashboardAction()
    {
        $this->handleRequest(
            array(
                'gapi_email'   => 'text',
                'gapi_view_id' => 'text',
            )
        );

        $this->getHelper()->getBodyView()
            ->setTemplatePath(__DIR__ . '/../../Resources/views/settings_dashboard.php')
            ->assignVars(
                array(
                    'action_form' => $this->url('/' . $this->getParameter('path') . '/dashboard/'),
                )
            );

        $this->displayTabs();
    }

    /**
     * Visualizza le tabs con le varie categorie di opzione
     */
    protected function displayTabs()
    {
        $this->getHelper()->getBodyView()
            ->assignVar('tabs', $this->getTabs());
    }

    /**
     * Restituisce le tabs disponibili
     *
     * @return array
     */
    protected function getTabs()
    {
        $translator = $this->getHelper()->getTranslator();
        $path = $this->getParameter('path');

        return array(
            (object)array('name'      => $translator->trans('Main'),
                          'link'      => $this->url("/{$path}/"),
                          'is_active' => ($this->getAction() == 'index')
            ),
            (object)array('name'      => $translator->trans('Company'),
                          'link'      => $this->url("/{$path}/company/"),
                          'is_active' => ($this->getAction() == 'company')
            ),
            (object)array('name'      => $translator->trans('Social'),
                          'link'      => $this->url("/{$path}/social/"),
                          'is_active' => ($this->getAction() == 'social')
            ),
            (object)array('name'      => $translator->trans('Dashboard'),
                          'link'      => $this->url("/{$path}/dashboard/"),
                          'is_active' => ($this->getAction() == 'dashboard')
            ),
        );
    }
}
