<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 * @package Application\Core
 */

namespace Application\Core;

use Pongho\Core\TemplateResponse;
use Pongho\Utilities\Inflector;

/**
 * Controller base.
 */
class Controller extends BaseController
{
	/**
	 * {@inheritdoc}
	 */
	protected function handleInvalidResponse($response)
	{
		$view = $this->getHelper()->getView();

		// Se il template non ha un filename impostato, lo imposto in base al nome del controller e dell'azione eseguita.
		if ( !$view->hasTemplate() )
		{
			$controller_base = substr(get_class($this), 0, -10);
			$controller_base = Inflector::underscore(Inflector::demodulize($controller_base));

			if ( $this->getAction() === 'index' )
			{
				$view->setTemplate($controller_base . '.php');
			}
			else
			{
				$view->setTemplate($controller_base . '_' . $this->getAction() . '.php');
			}
		}

		return new TemplateResponse($view, $this->getHelper()->getResponseHeaders());
	}

	/**
	 * Restituisce la vista.
	 *
	 * @access public
	 * @return \Pongho\Template\Theme
     *
     * @deprecated
	 */
	public function getView()
	{
		return $this->getHelper()->getView();
	}

    /**
     * {@inheritdoc}
     *
     * @deprecated
     */
    public function displayMessage($message, $is_error = false, array $parameters = array())
    {
        return $this->getHelper()->displayMessage($message, $is_error, $parameters);
    }
}
