<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 * @package Application\Core
 */

namespace Application\Core;

use Pongho\Core\Container as ContainerBase;

/**
 * Contenitore delle dipendenze.
 */
class Container extends ContainerBase
{
    public function __construct(array $parameters)
    {
        parent::__construct($parameters);

        $this->share('html2pdf', function () {
            trigger_error("The service 'html2pdf' is deprecated and should not be used.", E_USER_DEPRECATED);

            return new \HTML2PDF();
        });
    }
}
