<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Console\Command;

use Application\Core\Cron\TaskRunner;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * TaskCommand
 */
class TaskCommand extends Command
{
    /**
     * @var TaskRunner
     */
    protected $runner;

    /**
     * @param TaskRunner $runner
     */
    public function __construct(TaskRunner $runner)
    {
        $this->runner = $runner;

        parent::__construct();
    }

    /**
     * {@inheritdoc}
     */
    public function configure()
    {
        $this
            ->setName('task:run')
            ->setDescription('Runs all tasks in queue.');
    }

    /**
     * {@inheritdoc}
     */
    public function execute(InputInterface $input, OutputInterface $output)
    {
        while ($this->runner->run()) {

        }

        $output->writeln('Task executed.');
    }
}
