<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Console\Command;

use Application\Core\Installer\PonghoInstaller;
use Doctrine\DBAL\Connection;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class PonghoInstallCommand extends Command
{
    /**
     * @var Connection
     */
    protected $connection;

    /**
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;

        parent::__construct();
    }

    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('pongho:install')
            ->setDefinition(
                array(
                    new InputArgument('domain', InputArgument::REQUIRED, 'The domain for the site being installed'),
                )
            )
            ->setDescription('Installs Pongho');
    }

    /**
     * {@inheritdoc}
     */
    public function execute(InputInterface $input, OutputInterface $output)
    {
        $t = microtime(true);

        (new PonghoInstaller($this->connection))->install($input->getArgument('domain'));

        if ($output->getVerbosity() >= OutputInterface::VERBOSITY_VERBOSE) {
            $output->writeln('<info>Time: ' . (microtime(true) - $t) . '</info>');
        }
    }
}
