<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Console\Command;

use Application\Core\Application\Facade;
use Symfony\Component\Console\Command\Command;

/**
 * AbstractApplicationCommand
 */
abstract class AbstractApplicationCommand extends Command
{
    /**
     * @var Facade
     */
    protected $facade;

    /**
     * @param Facade $facade
     * @param null   $name
     */
    public function __construct(Facade $facade, $name = null)
    {
        $this->facade = $facade;

        parent::__construct($name);
    }
}
