<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\CommandBus\Command\User\Login;

use Application\Core\Model\Account;
use Pongho\Utilities\DateTime;

/**
 * LoginHandler
 */
class LoginHandler
{
    /**
     * @param LoginCommand $command
     * @return bool
     * @throws Exception\LoginExceptionInterface
     */
    public function handle(LoginCommand $command)
    {
        if (empty($command->getUsername())) {
            throw new Exception\FieldRequiredException('username');
        }

        if (empty($command->getPassword())) {
            throw new Exception\FieldRequiredException('password');
        }

        /** @var Account $user */

        if (preg_match(REGEXP_VALIDATE_EMAIL, $command->getUsername())) {
            // login by email address
            $user = Account::findByEmail($command->getUsername());
        } else {
            // login by username
            $user = Account::findByUsername($command->getUsername());
        }

        if (!$user) {
            throw new Exception\UserNotFoundException();
        }

        if ($user->getPassword() !== $command->getPassword()) {
            throw new Exception\PasswordException();
        }

        if (!$user->isActive()) {
            throw new Exception\UserNotActivatedException();
        }

        // TODO: spostare sul modello
        $user->last_login_at = new DateTime();
        $user->save();

        return true;
    }
}
