<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\CommandBus\Command\User\Login\Exception;

use Exception;

/**
 * FieldRequiredException
 */
class FieldRequiredException extends \Exception implements LoginExceptionInterface
{
    /**
     * @var string
     */
    protected $fieldName;

    /**
     * @param string         $fieldName
     * @param int            $code
     * @param Exception|null $previous
     */
    public function __construct($fieldName, $code = 0, Exception $previous = null)
    {
        parent::__construct('The field "%s" is required', $code, $previous);
    }

    /**
     * @return string
     */
    public function getFieldName()
    {
        return $this->fieldName;
    }
}
