<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Breadcrumb;

/**
 * BreadcrumbInterface
 */
interface BreadcrumbInterface
{
    /**
     * Permette di aggiungere un altro elemento al breadcrumb.
     *
     * La "briciola" che viene aggiunta può essere un’implementazione di CrumbInterface, ma anche qualsiasi
     * altro tipo di elemento. Se il tipo di "briciola" non è supportato, il metodo deve restituire una
     * eccezione di tipo InvalidArgumentException.
     *
     * @param mixed $crumb
     * @return $this
     * @throws \InvalidArgumentException
     */
    public function append($crumb);

    /**
     * Rimuove una briciola.
     *
     * @param string $crumb_id
     * @return $this
     */
    public function remove($crumb_id);

    /**
     * Restituisce tutte le briciole.
     *
     * @return CrumbInterface[]
     */
    public function all();

    /**
     * Imposta le opzioni per il rendering del breadcrumb. Le opzioni disponibili dipendono dall’implementazione.
     *
     * @param array $options
     * @return $this
     */
    public function setOptions(array $options = []);

    /**
     * {@inheritdoc}
     */
    public function __toString();

    /**
     * Restituisce il codice HTML per stampare il breadcrumb.
     *
     * @return string
     */
    public function render();
}
