<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Application;

/**
 * LoaderInterface.
 */
interface LoaderInterface
{
    /**
     * Carica le applicazioni.
     */
    public function load();

    /**
     * @param string $app_name
     * @return \Pongho\Core\Plugin
     */
    public function getKernel($app_name);

    /**
     * @param string $app_name
     * @return bool
     */
    public function kernelExists($app_name);

    /**
     * @param string $app_name
     * @return string|\Pongho\Core\Plugin
     */
    public function getKernelClass($app_name);
}
