<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Calendar
 */

namespace Application\Calendar\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

class Update66 extends SchemaUpdate
{
    protected function prepareSchema(Schema $schema)
    {
        $table = $schema->getTable('pongho_calendars');
        if (!$table->hasColumn('position')) {
            $table->addColumn('position', 'integer', ['unsigned' => true, 'default' => 0]);
        }

        if (!$table->hasColumn('slug')) {
            $table->addColumn('slug', 'string', ['length' => 100, 'default' => '']);
        }

        if (!$table->hasColumn('can_add')) {
            $table->addColumn('can_add', 'boolean', ['default' => true]);
        }

        if (!$table->hasColumn('can_edit_self')) {
            $table->addColumn('can_edit_self', 'boolean', ['default' => true]);
        }

        if (!$table->hasColumn('can_edit_others')) {
            $table->addColumn('can_edit_others', 'boolean', ['default' => false]);
        }

        if (!$table->hasColumn('can_delete_self')) {
            $table->addColumn('can_delete_self', 'boolean', ['default' => true]);
        }

        if (!$table->hasColumn('can_delente_others')) {
            $table->addColumn('can_delente_others', 'boolean', ['default' => false]);
        }

        if (!$table->hasColumn('can_view_others')) {
            $table->addColumn('can_view_others', 'boolean', ['default' => true]);
        }
    }
}
