<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Calendar
 */

namespace Application\Calendar\Routes;

use Application\Calendar\Model\Calendar;
use Pongho\Http\Request;
use Pongho\Routing\RouteInterface;

class CalendarRoute implements RouteInterface
{
    /**
     * Nome del controller.
     *
     * @var string
     */
    protected $controller;

    /**
     * Azione.
     *
     * @var string
     */
    protected $action = 'index';

    /**
     * Parametri.
     *
     * @var array
     */
    protected $parameters = [];

    public function match(Request $request)
    {
        if ($this->parameters['calendar'] = Calendar::findByPermalink($request->getPathInfo())) {
            $this->action = 'calendar';

            return true;
        }

        return false;
    }

    public function getController()
    {
        return \Application\Calendar\Controller\CalendarController::class;
    }

    public function getAction()
    {
        return $this->action;
    }

    public function getParameters()
    {
        return $this->parameters;
    }
}
