/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true */
/*global $, jQuery, Pongho */
$.fn.permalinkEditor = function () {
    "use strict";

    return $(this).each(function () {
        var field = $(this),
            title = field.find('.field-title'),
            handler = field.find('.permalink-handler').hide(),
            permalink = handler.find('.slug-permalink'),
            slugHandle = permalink.find('.slug-editor-handle'),
            editor = handler.find('.slug-editor'),
            slugField = editor.find('.slug-field'),
            confirmBtn = editor.find('.slug-editor-confirm'),
            cancelBtn = editor.find('.slug-editor-cancel');

        if (title.val()) {
            handler.show();
        }

        function setSlug() {
            var o = {
                'object': title.data('object-id'),
                'title': title.val(),
                'url': slugField.val(),
                'language': title.data('lang')
            };
console.log(o);
            $.getJSON(title.data('req'), o, function (data) {
                if (data.error) {
                    alert(data.message);
                } else {
                    slugField.val(data.slug);
                    slugHandle.text(data.slug);
                }
            });
        }

        title.on('blur', function () {
            setSlug();

            handler.show();

            if (!editor.is(':visible')) {
                permalink.show();
            }
        });

        slugHandle.on('click', function () {
            permalink.hide();
            editor.show();
        });

        confirmBtn.on('click', function () {
            setSlug();

            permalink.show();
            editor.hide();
        });

        cancelBtn.on('click', function () {
            permalink.show();
            editor.hide();

            slugField.val(slugHandle.text());
        });
    });
};

(function ($) {
    "use strict";

    var onCreatePanel = function (el) {
        var repeaterWrapper = $('#fieldset-calendar-shares', el),
            repeater = $('.repeater', repeaterWrapper),
            search = $('#field-calendar-user_id', el),
            cache = [];

        $('.repeater-add-row', repeaterWrapper).parent().remove();

        // Cache delle righe
        $(".repeater-row:not(.repeater-blank-row) input.user-id", repeater).each(function () {
            cache.push(parseInt($(this).val()));
        });

        // Eliminazione
        repeater.on('row_delete', function (event, row) {
            var id = parseInt(row.find("input.user-id").val()),
                pos = $.inArray(id, cache);

            if (pos >= 0) {
                delete cache[pos];
            }
        });

        // Inserimento
        search.keydown(function (event) {
            if (event.which === 13) {
                event.preventDefault();
            }
        }).autocomplete({
            source: function (request, response) {
                request.not_in = cache;
                $.get(search.data('url'), request, function (data) {
                    response(data);
                }, 'json');
            },
            select: function (event, ui) {
                search.val("");

                repeater.repeater('add', function (row) {
                    console.log(row);
                    var container = row.find('.repeater-main .repeater-fields');

                    container.find('.shares-user-name').html(ui.item.label);
                    container.find('input.user-id').val(ui.item.id);
                });

                cache.push(parseInt(ui.item.id));

                return false;
            }
        });

        $('.permalink-editor').permalinkEditor();

    }, tabsPanel = $('.form-wrapper');

    if (Pongho.action !== 'add') {
        tabsPanel.on('after-update', function () {
            onCreatePanel($(this));
        });
    }

    onCreatePanel(tabsPanel);

}(jQuery));
