<?php
/**
 * @var \Pongho\Form\BaseField                       $field
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var \Application\Calendar\Model\Calendar         $model
 * @var string                                       $action
 * @var string                                       $path
 */


$model->createPermalink();
$view = absolute_url($path . '/<span class="slug-editor-handle">' . ltrim((string) $field->getValue(), '/') . '</span>');

$model->createPermalink();
$edit_url = $field->getTag()
    . '<button type="button" class="slug-editor-confirm">' . $translator->trans('Ok') . '</button>'
    . '<button type="button" class="slug-editor-cancel">' . $translator->trans('Cancel') . '</button>';

$editor = absolute_url($path . '/' . ltrim($edit_url, '/'));

if ($action === 'edit' && !empty($model->slug)) {
    $href = url($path . '/' . ltrim($model->slug, '/'));
    $view .= sprintf(
        ' <a href="%s" class="permalink-preview" target="%s">%s</a>',
        $href,
        'calendar_' . md5($href),
        $translator->trans('View')
    );
}
?>
<div class="control-group permalink-handler">
    <label class="control-label" for="<?php echo $field->getId(); ?>"><?php echo $field->getLabel(); ?></label>

    <div class="controls slug-permalink"><?php echo $view; ?></div>
    <div class="controls slug-editor" style="display: none;"><?php echo $editor; ?></div>
</div>
