<?php
/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var string                                       $action_form
 * @var array                                        $enabled_languages
 */
?><form action="<?php echo $action_form; ?>" method="post" class="section">

    <h2><?php echo $translator->trans('Options'); ?></h2>

    <?php
    include 'tabs.php';
    include 'messages.php';
    ?>

    <fieldset class="panel">
        <p><?php echo $translator->trans('Panel for enabling languages for the current module'); ?></p>
    </fieldset>

    <fieldset class="panel">
        <h3><?php echo $translator->trans('Languages'); ?></h3>
        <table class="pongho-table">
            <thead>
            <tr>
                <th><?php echo $translator->trans('Language'); ?></th>
                <th><?php echo $translator->trans('Name'); ?></th>
                <th><?php echo $translator->trans('Path'); ?></th>
                <th><?php echo $translator->trans('Enabled'); ?></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($enabled_languages as $language_site_id => $language): ?>
                <tr>
                    <td><?php echo $language['language']->flag; ?><span><?php echo $language['language']->name; ?></span></td>
                    <td><input type="text" class="input_text" name="languages[<?php echo $language_site_id; ?>][name]" value="<?php echo $language['module']->name; ?>"/></td>
                    <td><input type="text" class="input_text" name="languages[<?php echo $language_site_id; ?>][path]" value="<?php echo $language['module']->path; ?>"/></td>
                    <td><input type="checkbox" name="languages[<?php echo $language_site_id; ?>][is_enabled]"<?php echo $language['module']->is_enabled ? ' checked="checked"' : ''; ?> /></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </fieldset>

    <fieldset class="btn">
        <input type="submit" value="<?php echo $translator->trans('Save'); ?>" class="primary" />
    </fieldset>

</form><!-- .section -->
