<?php
/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var \Pongho\Template\Html                        $html
 * @var string                                       $action_form
 * @var string                                       $value_default_calendar_admin_view
 * @var array                                        $default_calendar_admin_views
 * @var string                                       $value_min_calendar_day_time
 * @var string                                       $value_max_calendar_day_time
 * @var int                                          $value_first_day
 * @var array                                        $enabled_views
 * @var array                                        $value_enabled_views
 */
?><form action="<?php echo $action_form; ?>" method="post" class="section">

	<h2><?php echo $translator->trans('Options'); ?></h2>

	<?php
    include 'tabs.php';
    include 'messages.php';
    ?>

	<fieldset class="panel">
		<h3><?php echo $translator->trans('Main'); ?></h3>

		<dl class="extend">
			<dt><label for="field-enabled_views"><?php echo $translator->trans('Enabled views'); ?></label></dt>
			<dd class="small">
                <?php foreach ($enabled_views as $enabled_view => $view_name): ?>
                    <?php $checked = in_array($enabled_view, $value_enabled_views) ? ' checked="checked"' : ''; ?>
                    <label>
                        <input type="checkbox" name="options[enabled_views][]" value="<?php echo $enabled_view; ?>"<?php echo $checked; ?>>
                        <?php echo $view_name; ?>
                    </label>
                <?php endforeach; ?>
			</dd>
        </dl>

		<dl class="extend">
			<dt><label for="field-default-calendar-admin-view"><?php echo $translator->trans('Calendar administration view'); ?></label></dt>
			<dd class="small">
				<select name="options[default_calendar_admin_view]" id="field-default-calendar-admin-view">
					<?php echo $html->select($default_calendar_admin_views, $value_default_calendar_admin_view); ?>
				</select>
			</dd>
        </dl>

        <dl class="extend">
			<dt><label for="field-min-calendar-day-time"><?php echo $translator->trans('Starting time'); ?></label></dt>
			<dd class="small">
				<input class="input_text" type="text" id="field-min-calendar-day-time" name="options[min_calendar_day_time]" value="<?php echo $value_min_calendar_day_time; ?>" />
			</dd>
        </dl>

        <dl class="extend">
			<dt><label for="field-max-calendar-day-time"><?php echo $translator->trans('Ending time'); ?></label></dt>
			<dd class="small">
				<input class="input_text" type="text" id="field-max-calendar-day-time" name="options[max_calendar_day_time]" value="<?php echo $value_max_calendar_day_time; ?>" />
			</dd>
        </dl>

        <dl class="extend">
			<dt><label for="field-first-day"><?php echo $translator->trans('First week day'); ?></label></dt>
			<dd class="small">
				<select name="options[first_day]" id="field-first-day">
					<?php echo $html->select(array(0 => $translator->trans('Sunday'), 1 => $translator->trans('Monday')), $value_first_day); ?>
				</select>
			</dd>
		</dl>
	</fieldset>

	<fieldset class="btn">
		<input type="submit" value="<?php echo $translator->trans('Save'); ?>" class="primary" />
	</fieldset>

</form><!-- .section -->
