/**
 * Documentazione
 * http://arshaw.com/fullcalendar/docs/
 */
if (typeof $ === 'undefined') {
    throw "Manca jQuery";
}

if (typeof $.ui === 'undefined') {
    throw "Manca jQuery UI";
}

if (typeof XDate === 'undefined') {
    throw "Manca XDate";
}

if (typeof $.colorbox === 'undefined') {
    throw "Manca Colorbox";
}

var enable_debug = true;

function debug(name, functionArguments, supplementarData) {
    if (enable_debug) {
        console.group(name);
        if (supplementarData) {
            console.log(supplementarData);
        }
        console.log(functionArguments);
        console.groupEnd();
    }
}

Pongho.Calendar = Pongho.Calendar || {};

Pongho.Calendar.getDate = function (date) {
    return new XDate(date);
};

Pongho.Calendar.convertPonghoDateToDate = function (ponghoDate) {
    var date = ponghoDate;

    if (typeof ponghoDate == 'object') {
        date = ponghoDate.date;
    }

    return Pongho.Calendar.getDate(date);
};

Pongho.Calendar.prepareDate = function (date) {
    try {
        return Pongho.Calendar.getDate(date).toString('yyyy-MM-dd HH:mm');
    } catch (e) {
        return '';
    }
};

Pongho.Calendar.fixEndDate = function (endDate, startDate) {
    if (endDate === null) {
        return startDate;
    }

    return endDate;
};

/**
 * Funzione per gestire i campi particolari, ad esempio le checkbox
 * Se viene passato un valore, questo viene impostato nel campo, altrimenti viene restituito il valore del campo
 */
Pongho.Calendar.handleFieldType = function (field, value) {
    if (field === undefined) return false;

    if (field.is('[type="checkbox"]')) {
        if (value !== undefined) {
            field.attr('checked', value);
        } else {
            return field.is(':checked');
        }
    } else {
        if (value !== undefined) {
            // Se il campo è una data, consento di sovrascrivere l'ora
            if (field.hasClass('input_datetime')) {
                if (field.data('hours') !== undefined) {
                    var split = field.data('hours').split(':');
                    value = new XDate(value).setHours(split[0]).setMinutes(split[1]).toDate();

                    field.val(new XDate(value).toString('yyyy-MM-dd HH:mm'));
                }
            } else {
                // Altrimenti è un campo normale e ci inserisco il valore
                field.val(value);
            }
        } else {
            return field.val();
        }
    }

    return true;
};

Pongho.Calendar.viewEventPopup = function (calEvent, jsEvent, view) {
    debug('eventClick', arguments);
    var calendar = view.calendar,
        event_actions = calendar.options.event_actions;

    calendar.options.popup.open(calEvent, calendar, event_actions.view_url);
};

Pongho.Calendar.editEventPopup = function (calEvent, jsEvent, view) {
    debug('eventDblClick', arguments);

    if (calEvent.editable) {
        var calendar = view.calendar,
            event_actions = calendar.options.event_actions;
        calendar.options.popup.open(calEvent, calendar, event_actions.edit_url);
    }
};

Pongho.Calendar.editEvent = function (calendar, calEvent, data, url, revertFunc) {
    debug('editEvent', arguments);
    var index;

    if (calendar.options.beforeEventSaveCheck(calendar, calEvent, data)) {
        data.id = calEvent.id;

        data.participants = [];
        for (index in calEvent.participants) {
            if (calEvent.participants.hasOwnProperty(index)) {
                var obj = calEvent.participants[index];
                data.participants.push(obj);
            }
        }

        data = calendar.options.beforeEventSave(calendar, calEvent, data);

        $.ajax({
            data: data,
            type: 'POST',
            url: url,
            success: function (result) {
                if (result.success) {
                    if (calendar.options.disableRefetch) {
                        calendar.updateEvent(calEvent);
                    } else {
                        debug('refetch', {});
                        calendar.refetchEvents();
                    }
                } else {
                    alert(result.message);
                    revertFunc();
                }
            }
        });
    } else {
        revertFunc();
    }
};

/**
 * Defaults
 */
Pongho.Calendar.defaults = {
    'aspect_ratio_handling': 'auto',
    'editable': true,
    'event_actions' : {
        'add_url'    : '/please/define/add_event/',
        'edit_url'   : '/please/define/edit_event/[id]/',
        'view_url'   : '/please/define/event/[id]/',
        'drop_url'   : '/please/define/drop_event/[id]/',
        'resize_url' : '/please/define/resize_event/[id]/'
    },
    'popup' : Pongho.Calendar.Popup,
    'selectable': true,
    'selectHelper': true,
//    'dayClickCallback': Pongho.Calendar.dayClick,
//    'dropCallback': Pongho.Calendar.drop,
//    'eventClickCallback': Pongho.Calendar.eventClick,
//    'eventDoubleClickCallback': Pongho.Calendar.eventDoubleClick,
//    'eventDropCallback': Pongho.Calendar.eventDrop,
//    'eventRenderCallback': Pongho.Calendar.eventRender,
//    'eventResizeCallback': Pongho.Calendar.eventResize,
//    'eventResizeStartCallback': Pongho.Calendar.eventResizeStart,
//    'eventResizeStopCallback': Pongho.Calendar.eventResizeStop,
//    'selectCallback': Pongho.Calendar.select,
////        'loadUserRowCallback': loadUserRowCallback,
////        'addUserRowCallback': addUserRowCallback,
////        'eventCustomFieldsCallback': eventCustomFieldsCallback,
////        'eventSaveCustomFieldsCallback': eventSaveCustomFieldsCallback,
//    'beforeEventSaveCallback': Pongho.Calendar.beforeEventSave,
//    'afterEventSaveCallback': Pongho.Calendar.afterEventSave,
    'loading': function (isLoading /*, view */) {
        if (isLoading) {
            $('.fc-loading').show();
        } else {
            $('.fc-loading').hide();
        }
    },

    // Gestione del ridimensionamento
    'heightOffset' : 138, // Altezza del titolo di Pongho e titolo del modulo + tool del calendario
    'widthOffset' : 216, // Larghezza della sidebar di Pongho + margine destro

    // Localization
    'allDayText': 'Giornata<br>intera',
    'buttonText': {
        prev: '&nbsp;&#9668;&nbsp;',  // left triangle
        next: '&nbsp;&#9658;&nbsp;',  // right triangle
        prevYear: '&nbsp;&lt;&lt;&nbsp;', // <<
        nextYear: '&nbsp;&gt;&gt;&nbsp;', // >>
        today: 'Oggi',
        month: 'Mese',
        week: 'Settimana',
        day: 'Giorno',
        resourceDay: 'Risorse'
    },
    'columnFormat': {
        month: 'ddd',    // Mon
        week: 'ddd d/M', // Mon 9/7
        day: 'dddd d/M'  // Monday 9/7
    },
    'dayNames': ['Domenica', 'Lunedì', 'Martedì', 'Mercoledì', 'Giovedì', 'Venerdì', 'Sabato'],
    'dayNamesShort': ["Dom", "Lun", "Mar", "Mer", "Gio", "Ven", "Sab", "Dom"],
    'monthNames': ["Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio", "Giugno", "Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre"],
    'monthNamesShort': ["GEN", "FEB", "MAR", "APR", "MAG", "GIU", "LUG", "AGO", "SET", "OTT", "NOV", "DIC"],
    'timeFormat': 'HH:mm',
    'titleFormat': {
        //'month': 'MMMM yyyy',
        //'week': "MMM d[ yyyy]{ '&#8212;'[ MMM] d yyyy}",
        'day': 'dddd, d MMMM yyyy'
    }
};


/**
 * Callback
 */
Pongho.Calendar.defaults.dayClick = function (date, allDay, jsEvent, view) {
    debug('dayClick', arguments);

    // triggera anche selectCallback
    // non viene triggerato se vengono selezionati più giorni
    // non viene triggerato nella resourceDay se è attivata l'opzione "selectable"
};

Pongho.Calendar.defaults.drop = function (date, allDay, jsEvent, ui/*, event, cal, popup*/) {
    debug('drop', arguments);
//    var calendar,
//        calEvent = $(event).data('eventObject'),
//        split;
//
//    // Imposto le ore di inizio e fine predefinite per l'evento draggato
//    split = calEvent.startTime.split(':');
//    calEvent.start = new XDate(date).setHours(split[0]).setMinutes(split[1]).toDate();
//
//    split = calEvent.endTime.split(':');
//    calEvent.end = new XDate(date).setHours(split[0]).setMinutes(split[1]).toDate();
//
//    // Apro il colorbox per consentire di rifinire i dettagli (es se si vuole impostare un titolo diverso o una descrizione)
////    calEvent.pongho_action = 'addevent';
//
//    calendar.options.popup.open(calEvent, calendar);
};

Pongho.Calendar.defaults.eventClick = Pongho.Calendar.viewEventPopup;
Pongho.Calendar.defaults.eventDblClick = Pongho.Calendar.editEventPopup;

Pongho.Calendar.defaults.eventDrop = function (calEvent, dayDelta, minuteDelta, allDay, revertFunc, jsEvent, ui, view) {
    debug('eventDrop', arguments);
    var calendar = view.calendar,
        event_actions = calendar.options.event_actions,
        data,
        isResource = typeof calEvent.resourceId != 'undefined',
        startDate = Pongho.Calendar.prepareDate(calEvent.start),
        endDate = Pongho.Calendar.prepareDate(Pongho.Calendar.fixEndDate(calEvent.end, calEvent.start));

    data = {
        'calendar_id': (isResource ? calEvent.resourceId : calEvent.calendar),
        'category_id': (isResource && calEvent.resourceId === calEvent.calendar ? calEvent.category : undefined),
        'title': calEvent.title,
        'content': calEvent.description,
        'start_date_at': startDate,
        'end_date_at': endDate,
        'is_all_day': calEvent.allDay ? 1 : 0,
        'status': calEvent.status
    };

    Pongho.Calendar.editEvent(calendar, calEvent, data, event_actions.drop_url.replace('[id]', calEvent.id), revertFunc);
};

Pongho.Calendar.defaults.eventRender = function (calEvent, element) {
    //debug('eventRender', arguments);
    element.find('.fc-event-content').append('<span>' + calEvent.description + '</span>');
};

Pongho.Calendar.defaults.eventResize = function (calEvent, dayDelta, minuteDelta, revertFunc, jsEvent, ui, view) {
    debug('eventResize', arguments);
    var calendar = view.calendar,
        event_actions = calendar.options.event_actions,
        data,
        startDate = Pongho.Calendar.prepareDate(calEvent.start),
        endDate = Pongho.Calendar.prepareDate(Pongho.Calendar.fixEndDate(calEvent.end, calEvent.start));

    data = {
        'calendar_id': calEvent.calendar,
        'category_id': calEvent.category,
        'title': calEvent.title,
        'content': calEvent.description,
        'start_date_at': startDate,
        'end_date_at': endDate,
        'is_all_day': calEvent.allDay ? 1 : 0,
        'status': calEvent.status
    };

    Pongho.Calendar.editEvent(calendar, calEvent, data, event_actions.resize_url.replace('[id]', calEvent.id), revertFunc);
};

Pongho.Calendar.defaults.eventResizeStart = function (event, jsEvent, ui, view) {
    debug('eventResizeStart', arguments);
};

Pongho.Calendar.defaults.eventResizeStop = function (event, jsEvent, ui, view) {
    debug('eventResizeStop', arguments);
};

Pongho.Calendar.defaults.select = function (startDate, endDate, allDay, jsEvent, resourceId, view) {
    debug('select', arguments);
    var calendar = view.calendar,
        event_actions = calendar.options.event_actions;

    calendar.options.popup.open({
        'calendar_id': resourceId,
        'title': '',
        'start': startDate,
        'end': endDate,
        'allDay': allDay
    }, calendar, event_actions.add_url);

    calendar.unselect();
};

/**
 * Callback personalizzate
 */

Pongho.Calendar.defaults.afterEventSave = function (cal, calEvent, data) {
    debug('afterEventSave', arguments);
};

Pongho.Calendar.defaults.beforeEventSave = function (cal, calEvent, data) {
    debug('beforeEventSave', arguments);
    return data;
};

Pongho.Calendar.defaults.beforeEventSaveCheck = function (cal, calEvent, data) {
    debug('beforeEventSaveCheck', arguments);
    return (data.title !== '');
};

Pongho.Calendar.defaults.eventCustomFields = function (calEvent, popup) {
    debug('eventCustomFields', arguments);
};

Pongho.Calendar.defaults.eventSaveCustomFields = function (calEvent, popup, data) {
    debug('eventSaveCustomFields', arguments);
    return data;
};

(function () {
    'use strict';

    $.fn.ponghoFullCalendar = function (options) {
        var calendar = $(this),
            o = $.extend({}, Pongho.Calendar.defaults, options),
            loading = $('<div class="fc-loading">Caricamento in corso</div>');

        // Controllo della presenza di opzioni
        if ($.colorbox === undefined) {
            throw 'Colorbox plugin is required!';
        }

        // Gestione ratio di ridimensionamento del calendario
        function onWindowResize() {
            if (o.aspect_ratio_handling === 'auto') {
                var ratio = (window.innerWidth - o.widthOffset) / (window.innerHeight - o.heightOffset);
                calendar.fullCalendar('option', 'aspectRatio', ratio);
            }
        }

        $(window).resize(onWindowResize);
        onWindowResize();

        /**
         * Indicatore di caricamento per il fetch degli eventi
         */
        calendar.append(loading);

        return calendar.fullCalendar(o);
    };
}());
