/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true */
/*global $, jQuery, Pongho */
/**
 * Created by Daniele on 17/04/14.
 */

if (typeof $.fn.datepicker === 'undefined') {
    throw "Manca UI.DatePicker widget";
}

if (typeof $.fn.timepicker === 'undefined') {
    throw "Manca UI.TimePicker widget";
}

if (typeof $.fn.sliderAccess === 'undefined') {
    throw "Manca UI.sliderAccess widget";
}

if (typeof $.fn.repeater === 'undefined') {
    console.warn('Il repeater di Pongho non è stato caricato, non sarà utilizzato dal Popup');
}

if (typeof $.fn.newTabs === 'undefined') {
    console.warn('Le tabs di Pongho non sono state caricate, non saranno utilizzate dal Popup');
}

Pongho.Calendar = Pongho.Calendar || {};

// Le opzioni sono uguali per timepicker e datetimepicker perché a causa di un bug del timepicker, se vengono
// passate le stesse opzioni ad entrambe le istanze, la prima le va a sovrascrivere con qualche suo default
Pongho.Calendar.Popup = {
    timepickerOptions: {
        hourMin: 8,
        hourMax: 20,
        stepMinute: 30,
        dateFormat: 'yy-mm-dd',

        // dispositivi touch
        addSliderAccess: true,
        sliderAccessArgs: { touchonly: false }
    },
    datetimepickerOptions: {
        hourMin: 8,
        hourMax: 20,
        stepMinute: 30,
        dateFormat: 'yy-mm-dd',

        // dispositivi touch
        addSliderAccess: true,
        sliderAccessArgs: { touchonly: false }
    },
    colorbox: {
        'innerHeight'		: 500,
        'innerWidth'		: 640
    }
};

Pongho.Calendar.Popup.allDayHandler = function () {
    var self = this,
        allDay = self.content.find('#field-event-is_all_day'),
        changeCkb = function () {
            var dates = self.content.find('#fieldset-event-dates');

            if (allDay.is(':checked')) {
                dates.hide();
            } else {
                dates.show();
            }

            $.colorbox.resize();
        };

    allDay.on('change', changeCkb);
    changeCkb();
};

Pongho.Calendar.Popup.calendarHandler = function () {
    var self = this,
        calendars = self.content.find('#field-event-calendar_id');

    calendars.on('change', function () {
        var categories = self.content.find('#field-event-category_id'),
            url = categories.data('url').replace('[id]', calendars.val());

        $.ajax({
            url: url,
            type: 'GET',
            dataType: 'html',
            success: function (result) {
                categories.html(result);
            }
        });
    });
};

Pongho.Calendar.Popup.open = function (calendarEvent, calendar, actionUrl) {
    this.calendar = calendar;
    this.calendarEvent = calendarEvent;

    var options = {
        'href'				: actionUrl.replace('[id]', calendarEvent.id),
        'data'		: $.param({
            'handler'		: calendar.options.handler,
            'event_id'		: calendarEvent.id,
            'calendar_id'	: calendarEvent.calendar_id,
            'start'			: Pongho.Calendar.prepareDate(calendarEvent.start),
            'end'			: Pongho.Calendar.prepareDate(calendarEvent.end),
            'is_all_day'	: calendarEvent.allDay || 0
        }),
        onComplete: this.onComplete.bind(this),
        onClosed: this.onClosed.bind(this)
    };

    $.colorbox($.extend({}, this.colorbox, options));
};

Pongho.Calendar.Popup.onComplete = function () {
    this.panel = $('#calendar-popup');
    this.content = $('#cboxLoadedContent');
    this.url = $('form', this.content).attr('action');

    this.attachPlugins();

    this.content.on('click', '#button-event-cancel', this.onCancel.bind(this));
    this.content.on('click', '#button-event-delete', this.onDelete.bind(this));
    this.content.on('submit', 'form', this.onSave.bind(this));
};

Pongho.Calendar.Popup.attachPlugins = function () {
    if ($.fn.repeater !== undefined) {
        this.content.find('.repeater').repeater();
    }

    if ($.fn.newTabs !== undefined) {
        this.content.find('.tabs').newTabs();
    }

    this.content.find('.datepicker').datepicker();
    this.content.find('.timepicker').timepicker(this.timepickerOptions);
    this.content.find('.datetimepicker').datetimepicker(this.datetimepickerOptions);

    this.calendarHandler();
    this.allDayHandler();
};

Pongho.Calendar.Popup.onCancel = function () {
    //Pongho.Calendar.closeTrigger = 'cancel';
    $.colorbox.close();
};

Pongho.Calendar.Popup.onDelete = function (event) {
    var btn = $(event.target),
        self = this;
    //Pongho.Calendar.closeTrigger = 'delete';

    btn.addClass('busy');

    $.ajax({
        type: 'POST',
        url: self.calendar.options.event_actions.delete_url.replace('[id]', self.calendarEvent.id),
        success: function (result) {
            if (result.success) {
                self.calendar.removeEvents(self.calendarEvent.id);

                if (!self.calendar.options.disableRefetch) {
                    self.calendar.refetchEvents();
                }
            }

            $.colorbox.close();
        }
    });
};

Pongho.Calendar.Popup.onSave = function (event) {
    event.preventDefault();

    var self = this,
        form = $(event.target),
        btn = $('button[type=submit]', form);

    btn.addClass('busy');

    $.ajax({
        data: form.serialize(),
        type: 'POST',
        url: self.url + '?handler=' + self.calendar.options.handler,
        success: function (result) {
            self.content.html(result.form);
            self.attachPlugins();
            if (result.success) {
                if (result.action === 'add_event') {
                    if (self.calendar.options.disableRefetch) {
                        self.calendar.renderEvent(self.calendarEvent);
                    } else {
                        self.calendar.refetchEvents();
                    }
                } else {
                    var e = result.event;

                    // Aggiorna i dati dell'evento
                    self.calendarEvent.id = e.id;
                    self.calendarEvent.calendar = e.calendar_id;
                    self.calendarEvent.category = e.category_id;
                    self.calendarEvent.title = e.title;
                    self.calendarEvent.description = e.content;
                    self.calendarEvent.start = Pongho.Calendar.convertPonghoDateToDate(e.start_date_at);
                    self.calendarEvent.end = Pongho.Calendar.convertPonghoDateToDate(e.end_date_at);
                    self.calendarEvent.allDay = e.is_all_day;
                    self.calendarEvent.status = e.status;
                    self.calendarEvent.participants = e.participants;
                    self.calendarEvent.textColor = e.text_color;
                    self.calendarEvent.color = e.bg_color;
                    self.calendarEvent.author = e.author_id;

                    // Richiesto per la vista "resource view", di norma è il calendario stesso
                    self.calendarEvent.resourceId = e.calendar_id;

                    self.calendar.updateEvent(self.calendarEvent);
                }

                $.colorbox.close();
            }
        }
    });
};

Pongho.Calendar.Popup.onClosed = function () {
    //self.calendar.options.beforePopupCloseCallback(self.panel, self.calendar, self.calendarEvent);

    var data = {};
    this.panel.find('input, select, textarea').each(function () {
        var field = $(this);
        if (!field.is('[type="button"]')) {
            data[field.data('col') || field.attr('name')] = Pongho.Calendar.handleFieldType(field);
        }
    });

    //Pongho.Calendar.performAction(self.calendar, self.calendarEvent, data, self.url);
};
