<?php

/**
 * @var \Application\Calendar\Model\CalendarEvent $event
 * @var \Application\Core\Localization $lang
 */

?>
<div>
    <dl>
        <dt><?php echo $lang->get('calendar'); ?></dt>
        <dd><?php echo $event->calendar_id; ?></dd>
    </dl>
    <dl>
        <dt><?php echo $lang->get('calendar_event_title'); ?></dt>
        <dd><?php echo $event->title; ?></dd>
    </dl>
    <dl>
        <dt><?php echo $lang->get('calendar_category'); ?></dt>
        <dd><?php echo $event->category_id; ?></dd>
    </dl>
    <dl>
        <dt><?php echo $lang->get('calendar_event_author'); ?></dt>
        <dd><?php echo $event->author_id; ?></dd>
    </dl>
    <dl>
        <dt><?php echo $lang->get('calendar_event_is_all_day'); ?></dt>
        <dd><?php echo $event->is_all_day; ?></dd>
    </dl>
    <dl>
        <dt><?php echo $lang->get('calendar_event_start_date_at'); ?></dt>
        <dd><?php echo $event->start_date_at instanceof \Pongho\Utilities\DateTime ? $event->start_date_at->format('d-m-Y : H:i') : ''; ?></dd>
    </dl>
    <dl>
        <dt><?php echo $lang->get('calendar_event_end_date_at'); ?></dt>
        <dd><?php echo $event->end_date_at instanceof \Pongho\Utilities\DateTime ? $event->end_date_at->format('d-m-Y - H:i') : ''; ?></dd>
    </dl>
</div>
