<?php

namespace Application\Calendar\Model;

use ActiveRecord\Base;

/**
 * Gestisce i permessi per i singoli utenti all'interno di un calendario
 *
 * @property int $calendar_id
 * @property int $user_id
 * @property bool $can_add
 * @property bool $can_edit_self
 * @property bool $can_edit_others
 * @property bool $can_delete_self
 * @property bool $can_delete_others
 * @property bool $can_view_others
 */
class CalendarUser extends Base
{
    public static $table_name = 'calendars_users';

    public static $primary_key = ['calendar_id', 'user_id'];

    public static $belongs_to = [
        ['user', 'model' => \Application\Core\Model\Account::class],
    ];

    public static function findByCalendarAndUser($calendar_id, $user_id)
    {
        $options = [
            'conditions' => [
                'calendar_id = :calendar AND user_id = :user',
                'calendar' => $calendar_id,
                'user'     => $user_id,
            ],
        ];

        return self::first($options);
    }
}
