<?php

namespace Application\Calendar\Model;

use ActiveRecord\Base;

/**
 * @property int                             $calendar_event_id
 * @property int                             $user_id
 * @property string                          status
 * @property \Application\Core\Model\Account $user
 */
class CalendarEventUser extends Base
{
    public static $table_name = 'calendars_events_users';

    public static $primary_key = ['calendar_event_id', 'user_id'];

    public static $belongs_to = [
        ['user', 'model' => \Application\Core\Model\Account::class],
    ];

    public static function findByEventAndUser($event_id, $user_id)
    {
        $options = [
            'conditions' => [
                'calendar_event_id = :event AND user_id = :user',
                'event' => $event_id,
                'user'  => $user_id,
            ],
        ];

        return self::first($options);
    }
}
