<?php

namespace Application\Calendar\Model;

use ActiveRecord\Base;

/**
 * @property int $id
 * @property int $calendar_id
 * @property string $title
 */
class CalendarCategory extends Base
{
    public static $table_name = 'calendars_categories';

    public function delete($in_recursion = false)
    {
        return $this->updateCalendarEventsCategory() && parent::delete();
    }

    protected function updateCalendarEventsCategory()
    {
        $options = [
            'conditions' => [
                'calendar_id = :calendar AND category_id = :id',
                'calendar' => $this->calendar_id,
                'id'       => $this->id,
            ],
        ];

        foreach (CalendarEvent::all($options) as $event) {
            $event->category_id = null;

            if (!$event->save()) {
                return false;
            }
        }

        return true;
    }
}
