<?php

namespace Application\Calendar;

use Application\Calendar\DependencyInjection\AdminSidebarServiceProvider;
use Application\Calendar\DependencyInjection\CalendarServicesProvider;
use Application\Calendar\DependencyInjection\RoutingServiceProvider;
use Application\Calendar\DependencyInjection\TranslationServiceProvider;
use Application\Calendar\Installer\Installer;
use Application\Core\Model\Translation;
use Pongho\Core\Plugin;
use Pongho\EventDispatcher\Event;

class Kernel extends Plugin
{
    public const VERSION = '1.0.0-dev';

    public const FRONT_CONTROLLER = 'Application\\Calendar\\Controller\\CalendarController';

    public static function depends()
    {
        return ['Admin', 'Core'];
    }

    public function setUp()
    {
        return true;
    }

    public function load()
    {
        $this->container->register(new AdminSidebarServiceProvider());
        $this->container->register(new TranslationServiceProvider());
        $this->container->register(new RoutingServiceProvider());
        $this->container->register(new CalendarServicesProvider());

        $this->connect('admin.translations.filter_partitions', 'filterTranslationsPartitions');
    }

    public function install()
    {
        Installer::newInstance($this->container)->install();

        // Traduzioni
        Translation::putTranslation('add_calendar', 'Aggiungi calendario', 'calendar', 'it_IT');
        Translation::putTranslation('add_first_calendar', 'Aggiungi il primo calendario', 'calendar', 'it_IT');
        Translation::putTranslation('calendar', 'Calendario', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_categories', 'Categorie eventi', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_category', 'Categoria evento', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_color', 'Colore', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_enabled_views', 'Viste abilitate', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_event', 'Evento', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_event_dates', 'Date evento', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_event_details', 'Dettagli evento', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_event_end', 'Fine', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_event_full_day', 'Giorno intero', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_event_participants', 'Partecipanti all’evento', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_event_start', 'Inizio', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_name', 'Nome calendario', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_owner', 'Proprietario', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_participants', 'Partecipanti', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_permissions_explain', 'Configura i permessi pubblici per il calendario, tutti gli utenti potranno effettuare le seguenti azioni abilitate:', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_public_permissions', 'Permessi pubblici', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_select_category', 'Seleziona categoria', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_select_status', 'Seleziona stato', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_share_can_add', 'Aggiunge', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_share_can_delete_others', 'Elimina tutti', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_share_can_delete_self', 'Elimina propri', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_share_can_edit_others', 'Modifica tutti', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_share_can_edit_self', 'Modifica propri', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_share_can_view_others', 'Vede tutti', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_share_user', 'Condividi calendario con', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_shares', 'Condivisione calendario', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_shares_and_permissions', 'Condivisione e permessi', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_shares_explain', 'Configura le condivisioni e i permessi specifici per utente.<br>I permessi specifici sovrascrivono completamente i permessi pubblici', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_status', 'Stato', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_status_active', 'Abilitato', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_status_disabled', 'Disabilitato', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_status_open', 'Aperto', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_status_closed', 'Chiuso', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_status_confirmed', 'Confermato', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_title', 'Calendario eventi', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_url', 'Url calendario', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_view_agenda_day', 'Vista giornaliera', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_view_agenda_week', 'Vista settimanale', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_view_month', 'Vista mensile', 'calendar', 'it_IT');
        Translation::putTranslation('calendar_view_resource_day', 'Vista risorse', 'calendar', 'it_IT');
        Translation::putTranslation('calendars', 'Calendari', 'calendar', 'it_IT');
        Translation::putTranslation('default_calendar_admin_view', 'Vista calendario amministrazione', 'calendar', 'it_IT');
        Translation::putTranslation('edit_calendar', 'Modifica calendario', 'calendar', 'it_IT');
        Translation::putTranslation('first_week_day', 'Primo giorno sett.', 'calendar', 'it_IT');
        Translation::putTranslation('max_calendar_day_time', 'Orario di fine', 'calendar', 'it_IT');
        Translation::putTranslation('min_calendar_day_time', 'Orario di inizio', 'calendar', 'it_IT');
        Translation::putTranslation('modules_add_calendar', 'Aggiungi calendario', 'calendar', 'it_IT');
        Translation::putTranslation('modules_calendar', 'Calendario', 'calendar', 'it_IT');
        Translation::putTranslation('modules_calendars', 'Calendari', 'calendar', 'it_IT');
        Translation::putTranslation('search_participant', 'Cerca partecipante', 'calendar', 'it_IT');
    }

    public function uninstall()
    {
        // Elimino le traduzioni
        $options = [
            'conditions' => [
                'application = :application',
                'application' => 'calendar',
            ],
        ];

        /** @var \Application\Core\Model\Translation $translation */
        foreach (Translation::all($options) as $translation) {
            $translation->delete();
        }

        Installer::newInstance($this->container)->uninstall();
    }

    public function enable()
    {
    }

    public function disable()
    {
    }

    public function filterTranslationsPartitions(Event $event, array $partitions)
    {
        $partitions[] = 'calendar';

        return $partitions;
    }
}
