<?php

namespace Application\Calendar\Handler;

use Application\Calendar\Model\CalendarEvent;
use Pongho\Http\Request;
use Pongho\Template\HeadHelper;

interface ViewInterface
{
    /**
     * @return string
     */
    public function getName();

    /**
     * @param HeadHelper $head
     */
    public function populateHead(HeadHelper $head);

    /**
     * @param CalendarEvent $event
     * @param Request       $request
     * @return \Pongho\Form\Form
     */
    public function getPopupForm(CalendarEvent $event, Request $request);

    /**
     * @return \Application\Calendar\Model\Calendar[]
     */
    public function getCalendars();

    /**
     * @return \Application\Calendar\Model\CalendarEvent[]
     */
    public function getEvents();

    /**
     * @return string
     */
    public function getPopupViewTemplatePath();

    /**
     * @return string
     */
    public function getPopupEditTemplatePath();
}
