<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Calendar
 */

namespace Application\Calendar\Handler\View;

use Application\Calendar\Handler\SingleViewInterface;

class SingleView extends BaseView implements SingleViewInterface
{
    protected $calendar_id;

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'public_single';
    }

    /**
     * Imposta il calendario.
     *
     * @param $calendar_id
     */
    public function setCalendar($calendar_id)
    {
        $this->calendar_id = $calendar_id;
    }

    /**
     * {@inheritdoc}
     */
    protected function getJsCalendars()
    {
        return [$this->calendar_id];
    }

    /**
     * {@inheritdoc}
     */
    public function getJsCalendarOptions(array $options = [])
    {
        $options = array_replace_recursive(
            [
                'header' => [
                    'center' => 'agendaDay,agendaWeek,month',
                ],
            ],
            $options
        );

        return parent::getJsCalendarOptions($options);
    }

    /**
     * {@inheritdoc}
     */
    protected function getResources()
    {
        return [];
    }

    protected function getDefaultJsOptions()
    {
        $options = parent::getDefaultJsOptions();

        $options['event_actions']['add_url'] = url("/api/calendar/add_event/{$this->calendar_id}/");

        return $options;
    }
}
