<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Calendar
 */

namespace Application\Calendar\Handler\View;

class ResourcesView extends BaseView
{
    public function getName()
    {
        return 'resources';
    }

    /**
     * {@inheritdoc}
     */
    public function getJsCalendarOptions(array $options = [])
    {
        $options = array_replace_recursive(
            [
                'header'      => [
                    'left'  => 'prev,next,today title',
                    'right' => 'resourceDay',
                ],
                'resources'   => $this->getResources(),
                'defaultView' => 'resourceDay',
            ],
            $options
        );

        return parent::getJsCalendarOptions($options);
    }

    /**
     * @return array
     */
    protected function getResources()
    {
        $resources = [];
        foreach ($this->data->getCalendars() as $calendar) {
            $resources[] = [
                'name' => $calendar->title,
                'id'   => $calendar->id,
            ];
        }

        return $resources;
    }
}
