<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package \Application\Calendar
 */

namespace Application\Calendar\Handler\View;

use Application\Calendar\Handler\DataInterface;
use Application\Calendar\Handler\PopupInterface;
use Application\Core\Model\ModuleSite;

class AdminView extends BaseView
{
    /**
     * @var \Application\Core\Model\ModuleSite
     */
    protected $module_site;

    /**
     * @param DataInterface  $data
     * @param PopupInterface $popup
     * @param ModuleSite     $module_site
     */
    public function __construct(DataInterface $data, PopupInterface $popup, ModuleSite $module_site)
    {
        $this->module_site = $module_site;

        parent::__construct($data, $popup);
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'admin';
    }

    /**
     * {@inheritdoc}
     */
    public function getJsCalendarOptions(array $options = [])
    {
        // Pulsanti di selezione della vista e altre dipendenze
        $views = [];
        $time_formats = [];
        foreach ($this->module_site->getOption('enabled_views') as $enabled_view) {
            $views[] = $enabled_view;
            $time_formats[$enabled_view] = 'H:mm{ - H:mm}';
        }

        $options = array_replace_recursive(
            [
                'aspect_ratio_handling' => 'fixed',
                'axisFormat'            => 'H:mm',
                'contentHeight'         => 800,
                'firstDay'              => $this->module_site->getOption('first_day'),
                'header'                => [
                    'left'  => 'prev,next,today title',
                    'right' => implode(',', $views),
                ],
                'minTime'               => $this->module_site->getOption('min_calendar_day_time'),
                'maxTime'               => $this->module_site->getOption('max_calendar_day_time'),
                'defaultView'           => $this->module_site->getOption('default_calendar_admin_view'),
                'resources'             => $this->getResources(),
                'selectable'            => true,
                'selectHelper'          => true,
                'timeFormat'            => $time_formats,
            ],
            $options
        );

        return parent::getJsCalendarOptions($options);
    }

    /**
     * @return array
     */
    protected function getResources()
    {
        $resources = [];
        foreach ($this->data->getCalendars() as $calendar) {
            $resources[] = [
                'name' => $calendar->title,
                'id'   => $calendar->id,
            ];
        }

        return $resources;
    }
}
