<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Calendar
 */

namespace Application\Calendar\Handler;

use Application\Calendar\Model\CalendarEvent;
use Pongho\Http\Request;
use Pongho\Template\HeadHelper;

interface PopupInterface
{
    /**
     * @param HeadHelper $head
     */
    public function populateHead(HeadHelper $head);

    /**
     * @param CalendarEvent $event
     * @param DataInterface $data
     * @param Request       $request
     * @return \Pongho\Form\Form
     */
    public function getForm(CalendarEvent $event, DataInterface $data, Request $request);

    /**
     * @return string
     */
    public function getView();
}
