<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Calendar
 */

namespace Application\Calendar\Handler\Popup;

use Application\Admin\Form\FormConfig;
use Application\Calendar\Handler\DataInterface;
use Pongho\Form\Subject\ModelSubject;
use Pongho\Http\Request;

class AdminSinglePopup extends AdminPopup
{
    /**
     * {@inheritdoc}
     */
    protected function getFormConfig(ModelSubject $subject, DataInterface $data, Request $request)
    {
        $config = parent::getFormConfig($subject, $data, $request);

        $field = $config->getField('content/main/event/calendar_id');
        $field['class'] = \Pongho\Form\Field\HiddenField::class;
        unset($field['options']);

        return $config;
    }
}
