<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Calendar
 */

namespace Application\Calendar\Handler\Popup;

use Application\Admin\Form\FormConfig;
use Application\Calendar\Handler\DataInterface;
use Pongho\Form\Subject\ModelSubject;
use Pongho\Http\Request;

class AdminPopup extends BasePopup
{
    /**
     * @param ModelSubject  $subject
     * @param DataInterface $data
     * @param Request       $request
     * @return FormConfig
     */
    protected function getFormConfig(ModelSubject $subject, DataInterface $data, Request $request)
    {
        $config = new FormConfig('event', $subject, $this->lang);

        $config->addBaseStructure('main', '/');
        $config->addTab('content/main', $this->lang->get('main'));
        $config->addTab('content/participants', $this->lang->get('participants'));

        $config->addFields(
            'actions',
            [
                'cancel' => [
                    'class'    => \Pongho\Form\Field\ButtonField::class,
                    'label'    => $this->lang->get('cancel'),
                    'settings' => [
                        'value' => 'cancel',
                    ],
                ],
                'delete' => [
                    'class'    => \Pongho\Form\Field\ButtonField::class,
                    'label'    => $this->lang->get('delete'),
                    'settings' => [
                        'value' => 'delete',
                    ],
                ],
            ]
        );

        $config->addPanel('content/main/event');
        $config->addPanel('content/main/dates');
        $config->addPanel('content/main/details');
        $config->addFields(
            'content/main/event',
            [
                'calendar_id' => [
                    'class'      => \Pongho\Form\Field\SelectField::class,
                    'label'      => $this->lang->get('calendar'),
                    'attributes' => ['required' => 'required'],
                    'options'    => $data->getCalendarSelectOptions(),
                    'settings'   => [
                        'placeholder' => $this->lang->get('select_calendar'),
                    ],
                ],
                'title'       => [
                    'class'      => \Pongho\Form\Field\TextField::class,
                    'label'      => $this->lang->get('title'),
                    'attributes' => ['required' => 'required'],
                ],
                'content'     => [
                    'class' => \Pongho\Form\Field\TextareaField::class,
                    'label' => $this->lang->get('description'),
                ],
                'is_all_day'  => [
                    'class' => \Pongho\Form\Field\CheckboxField::class,
                    'label' => $this->lang->get('calendar_event_full_day'),
                ],
            ]
        );

        $config->addFields(
            'content/main/dates',
            [
                'start_date_at' => [
                    'class' => \Pongho\Form\Field\DateTimeField::class,
                    'label' => $this->lang->get('calendar_event_start'),
                ],
                'end_date_at'   => [
                    'class' => \Pongho\Form\Field\DateTimeField::class,
                    'label' => $this->lang->get('calendar_event_end'),
                ],
            ]
        );

        // Prendo il calendar_id sempre da POST perché posso averlo modificato nell'evento, altrimenti caricherei
        // le categorie del precedente calendario, se non sono in POST o non mi è stato passato, allora prendo
        // come default quello del Subject
        $calendar_id = $request->post->get('event[calendar_id]', $subject->get('calendar_id'), true);

        $config->addFields(
            'content/main/details',
            [
                'category_id' => [
                    'class'      => \Pongho\Form\Field\SelectField::class,
                    'label'      => $this->lang->get('calendar_category'),
                    'attributes' => [
                        'data-url' => url('/api/calendar/categories/[id]/'),
                    ],
                    'options'    => $data->getCategoriesSelectOptions($calendar_id),
                    'settings'   => [
                        'placeholder' => $this->lang->get('calendar_select_category'),
                    ],
                ],
                'status'      => [
                    'class'    => \Pongho\Form\Field\SelectField::class,
                    'label'    => $this->lang->get('status'),
                    'options'  => $this->calendar_event_states,
                    'settings' => [
                        'placeholder' => $this->lang->get('calendar_select_status'),
                    ],
                ],
            ]
        );

        $config->addField(
            'content/participants/users',
            [
                'class'      => \Pongho\Form\Repeater\ModelRepeater::class,
                'attributes' => ['class' => 'panel'],
                'settings'   => [
                    'filter_model' => \Application\Calendar\Model\CalendarEventUser::class,
                    'row_settings' => [
                        'show-delete'  => true,
                        'delete-label' => $this->lang->get('remove'),
                    ],
                ],
            ]
        );

        $config->addRepeaterRow('content/participants/users');

        return $config;
    }
}
