<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Calendar
 */

namespace Application\Calendar\Handler;

interface DataInterface
{
    /**
     * @return \Application\Calendar\Model\Calendar[]
     */
    public function getCalendars();

    /**
     * Restituisce gli eventi per il calendario, metodo estendibile
     *
     * @throws \InvalidArgumentException
     * @internal param array $options
     *
     * @return array
     */
    public function getEvents(/* args */);

    /**
     * @return array
     */
    public function getCalendarSelectOptions();

    /**
     * @param int $calendar_id
     * @return array
     */
    public function getCategoriesSelectOptions($calendar_id);
}
