<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Calendar
 */

namespace Application\Calendar\DependencyInjection;

use Application\Core\I18n\Translation\Translator;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class TranslationServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->extend(
            'translator',
            function (Translator $translator, Container $container): void {
                /** @var \Application\Core\User $user */
                $user = $container->get('current_user');
                $culture = $user->getAccount()->getLanguage()->getCulture();
                $translator->addResource('pongho_app', 'Calendar', $culture);
            },
        );
    }
}
