<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Calendar
 */

namespace Application\Calendar\DependencyInjection;

use Application\Calendar\Routes\CalendarRoute;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Routing\RoutesCollection;

class RoutingServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->extend(
            'routes_collection',
            function (RoutesCollection $collection, Container $container): void {
                /** @var \Pongho\Http\Request $request */
                $request = $container->get('request');

                if (substr($request->getPathInfo(), 0, 8) !== '/pongho/') {
                    $collection->add('calendar', new CalendarRoute(), -1);
                } else {
                    /** @var \Application\Core\User $user */
                    $user = $container->get('current_user');

                    if ($user->isFounder() && $collection->has('calendar')) {
                        echo '<p class="alert warning">Rimuovi la rotta del calendario dal file routes.php<p>';
                    }
                }
            },
        );
    }
}
