<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Calendar
 */

namespace Application\Calendar\DependencyInjection;

use Application\Admin\AdminSidebar\Sidebar;
use Application\Calendar\Controller\Admin\CalendarController;
use Application\Calendar\Controller\Admin\CalendarOptionsController;
use Application\Calendar\Kernel;
use Application\Core\Model\Module;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class AdminSidebarServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->extend('admin_sidebar', function (Sidebar $sidebar, Container $container): void {
            /**
             * @var \Application\Core\I18n\Translation\Translator $translator
             * @var \Application\Core\User                        $user
             */
            $translator = $container->get('translator');
            $user = $container->get('current_user');

            if ($user->hasPermit('calendar.admin')) {
                $sidebar->addPanel($translator->trans('Calendars'), 'calendars', 'calendar', Sidebar::POS_APPS);

                if ($module = $this->getCalendarModule()) {
                    $sidebar->addItem(
                        $translator->trans('Calendar'),
                        '/calendar/view/',
                        'calendars',
                        Sidebar::POS_PANEL_ACTIONS,
                        CalendarController::class,
                        $module->id,
                    );

                    $sidebar->addItem(
                        $translator->trans('List'),
                        '/calendar/',
                        'calendars',
                        Sidebar::POS_PANEL_ACTIONS,
                        CalendarController::class,
                        $module->id,
                    );

                    $sidebar->addItem(
                        $translator->trans('Add'),
                        '/calendar/add/',
                        'calendars',
                        Sidebar::POS_PANEL_ACTIONS,
                        CalendarController::class,
                        $module->id,
                    );

                    if ($user->isFounder()) {
                        $sidebar->addItem(
                            $translator->trans('Options'),
                            '/calendar-options/',
                            'calendars',
                            Sidebar::POS_PANEL_SETTINGS,
                            CalendarOptionsController::class,
                            $module->id,
                        );
                    }
                } else {
                    echo '<p class="alert error">L\'applicazione Calendar non è correttamente configurata, sembra mancare il modulo<p>';
                }
            }
        });
    }

    private function getCalendarModule(): Module
    {
        $options = [
            'conditions' => [
                'controller = ?',
                Kernel::FRONT_CONTROLLER,
            ],
            'cachable'   => true,
        ];

        return Module::first($options);
    }
}
