<?php

namespace Application\Calendar\Controller;

use Application\Calendar\Model\Calendar;
use Application\Core\Controller;
use Pongho\Http\Exception\HttpNotFoundException;

class CalendarController extends Controller
{
    /**
     * Home page del modulo Calendario.
     *
     * Visualizza un calendario globale con gli eventi di tutti i calendari
     * Gestisce:
     * - tutti i calendari
     * - tutti i calendari dell'utente corrente
     * - tutti i calendari condivisi con l'utente corrente
     * - 404
     */
    public function indexAction()
    {
        if ($response = $this->getHelper()->notifyUntil($this, 'calendar.index_action')) {
            return $response;
        }

        $handler_name = 'calendar_view_handler.' . $this->getHelper()->filter($this, 'calendar.index.filter_calendar_handler', 'base');

        /** @var \Application\Calendar\Handler\ViewInterface $handler */
        $handler = $this->getContainer()->get($handler_name);

        $this->getHelper()->getTheme()
            ->setTemplate($this->getHelper()->filter($this, 'calendar.index.filter_template', '/calendar/index.php'));

        $footerHelper = $this->getHelper()->getThemeFooterHelper();
        $footerHelper->javascript->add(pongho_url('/Application/Admin/Resources/vendor/fullcalendar/fullcalendar.min.js?v=' . filemtime(PONGHO_PATH . '/Application/Admin/Resources/vendor/fullcalendar/fullcalendar.min.js')));
        $footerHelper->javascript->addInline('var Pongho = {};'); // necessario perché non sono in admin e quindi non viene aggiunto "da solo"

        $this->getHelper()->notify($this, 'calendar.index.before_head');

        $headHelper = $this->getHelper()->getThemeHeaderHelper();
        $handler->populateHead($headHelper);

        $footerHelper->javascript->add(pongho_url('/Application/Core/Resources/public/js/polyfill.js?v=' . filemtime(PONGHO_PATH . '/Application/Core/Resources/public/js/polyfill.js')));
        $footerHelper->javascript->add(pongho_url('/Application/Calendar/Resources/public/js/jquery.calendar.js?v=' . filemtime(PONGHO_PATH . '/Application/Calendar/Resources/public/js/jquery.calendar.js')));

        $this->getHelper()->notify($this, 'calendar.index.after_set_view');

        return null;
    }

    /**
     * Visualizza un singolo calendario
     */
    public function calendarAction()
    {
        if ($response = $this->notifyUntil('calendar.calendar_action')) {
            return $response;
        }

        /** @var Calendar $calendar */
        $calendar = $this->getParameter('calendar');

        $handler_name = 'calendar_view_handler.' . $this->filter('calendar.view.filter_calendar_handler', 'public_single');

        /** @var \Application\Calendar\Handler\SingleViewInterface $handler */
        $handler = $this->getContainer()->get($handler_name);
        $handler->setCalendar($calendar->id);

        $this->getHelper()->getTheme()
            ->setTemplate($this->getHelper()->filter($this, 'calendar.view.filter_template', '/calendar/calendar.php'));

        $footerHelper = $this->getHelper()->getThemeFooterHelper();
        $footerHelper->javascript->add(pongho_url('/Application/Admin/Resources/vendor/fullcalendar/fullcalendar.min.js?v=' . filemtime(PONGHO_PATH . '/Application/Admin/Resources/vendor/fullcalendar/fullcalendar.min.js')));
        $footerHelper->javascript->addInline('var Pongho = {};'); // necessario perché non sono in admin e quindi non viene aggiunto "da solo"

        $this->getHelper()->notify($this, 'calendar.view.before_head');

        $handler->populateHead($this->getHead());

        $footerHelper->javascript->add(pongho_url('/Application/Core/Resources/public/js/polyfill.js?v=' . filemtime(PONGHO_PATH . '/Application/Core/Resources/public/js/polyfill.js')));
        $footerHelper->javascript->add(pongho_url('/Application/Calendar/Resources/public/js/jquery.calendar.js?v=' . filemtime(PONGHO_PATH . '/Application/Calendar/Resources/public/js/jquery.calendar.js')));

        $this->getHelper()->notify($this, 'calendar.view.after_set_view');

        return null;
    }

    /**
     *
     */
    public function getCalendarsSelectOptions()
    {
        $calendars = [];
        $colors = $this->getColors();

        $options = $this->filter("calendar.filter_calendars_select_options", ['order' => 'title ASC']);

        foreach (Calendar::all($options) as $calendar) {
            $calendars[$calendar->id] = [
                'title'           => $calendar->title,
                'data-text-color' => $colors[$calendar->color]['text'],
                'data-bg-color'   => $colors[$calendar->color]['bg'],
            ];
        }

        return $calendars;
    }

    /**
     *
     */
    public function getColors()
    {
        $cal_colors = Calendar::$colors;
        $cal_colors = $this->filter("calendar.filter_colors", $cal_colors);

        return $cal_colors;
    }

    /**
     *
     */
    public function getStates()
    {
        $states = Calendar::$calendar_states;
        $states = $this->filter("calendar.filter_states", $states);

        return $states;
    }

    /**
     *
     */
    public function __call($method, array $arguments)
    {
        if ($response = $this->notifyUntil('calendar.method_not_found', ['method' => $method, 'arguments' => $arguments])) {
            return $response;
        }

        throw new HttpNotFoundException();
    }

    /**
     *
     */
    public function getEventStates()
    {
        $states = Calendar::$event_states;
        $states = $this->filter("calendar.filter_event_states", $states);

        return $states;
    }
}
