<?php

namespace Application\Calendar\Controller;

use ActiveRecord\Column;
use Application\Calendar\Model\Calendar;
use Application\Calendar\Model\CalendarCategory;
use Application\Calendar\Model\CalendarEvent;
use Application\Calendar\Model\CalendarEventUser;
use Application\Core\Controller as Base;
use Application\Core\Model\Account;
use Pongho\Core\TemplateResponse;
use Pongho\Http\Exception\HttpException;
use Pongho\Http\Exception\HttpNotFoundException;
use Pongho\Http\JsonResponse;
use Pongho\Utilities\DateTime;

/** @deprecated */
class AjaxController extends Base
{
    /**
     * Aggiorna i partecipanti all'evento
     */
    protected function updateParticipants(CalendarEvent $event, array $post_participants)
    {
        $flat_participants = [];
        foreach ($post_participants as $key => $participant) {
            if (is_numeric($key)) {
                $flat_participants[$participant['user_id']] = [];

                foreach ($participant as $field => $value) {
                    $flat_participants[$participant['user_id']][$field] = $value;
                }
            }
        }

        $participants = [];

        // Cancellazione e aggiornamento
        foreach ($event->getParticipants() as $participant) {
            // Il partecipante (db) non c'è nell'elenco dei partecipanti: lo elimino
            if (!array_key_exists($participant->user_id, $flat_participants)) {
                $participant->delete();
            } else {
                // Salvo il modello aggiornando gli attributi
                $attributes = $participant->attributes;

                foreach ($flat_participants[$participant->user_id] as $field => $value) {
                    $attributes[$field] = ($value === 'null' ? null : $value);
                }

                $attributes = $this->parseFields($attributes, CalendarEventUser::columns());

                $participant->updateAttributes($attributes);

                if ($participant->save()) {
                    // Se il salvataggio è andato a buon fine, aggiorno gli attributi, altrimenti ...
                    $attributes = [];
                    foreach ($flat_participants[$participant->user_id] as $field => $value) {
                        $attributes[$field] = $value instanceof DateTime ? $value->format('d-m-Y') : $value;
                    }

                    $participants[] = $attributes;
                }
            }
        }

        // Aggiunta
        foreach ($flat_participants as $id => $participant) {
            if (CalendarEventUser::findByEventAndUser($event->id, $id) === null) {
                $attributes = [];
                foreach ($participant as $field => $value) {
                    $attributes[$field] = ($value === 'null' ? null : $value);
                }

                if (!array_key_exists('calendar_event_id', $attributes)) {
                    $attributes['calendar_event_id'] = $event->id;
                }

                $attributes = $this->parseFields($attributes, CalendarEventUser::columns());

                $p = new CalendarEventUser($attributes);

                if ($p->save()) {
                    // Se il salvataggio è andato a buon fine, aggiorno gli attributi, altrimenti ...
                    foreach ($attributes as $field => $value) {
                        $attributes[$field] = $value instanceof DateTime ? $value->format('d-m-Y') : $value;
                    }

                    // Campi supplementari
                    $attributes['label'] = $p->user->name(true);

                    $participants[] = $attributes;
                }
            }
        }

        return $participants;
    }

    protected function parseFields($post, $columns)
    {
        // Ciclo le colonne del database
        foreach ($columns as $name => $column) {
            switch ($column->type) {
                case Column::STRING:
                    if (array_key_exists($name, $post)) {
                        $attributes[$name] = $post[$name];
                    }

                    break;

                case Column::DECIMAL:
                case Column::INTEGER:
                    if (array_key_exists($name, $post)) {
                        $attributes[$name] = intval($post[$name]);

                        if (!$attributes[$name]) {
                            $attributes[$name] = null;
                        }
                    }

                    break;

                case Column::BOOLEAN:
                    if (array_key_exists($name, $post)) {
                        //attenzione con i POST in Ajax, il valore è 'true' o 'false' in stringa!
                        $attributes[$name] = $post[$name] && $post[$name] !== 'false';
                    } else {
                        $attributes[$name] = false;
                    }

                    break;

                case Column::DATETIME:
                case Column::DATE:
                    if (array_key_exists($name, $post)) {
                        if ($post[$name] instanceof DateTime) {
                            $attributes[$name] = $post[$name];
                        } else {
                            $attributes[$name] = new DateTime($post[$name]);
                        }
                    }

                    break;

                default:
                    break;
            }
        }

        return $attributes;
    }

    /**
     * Azioni
     */
    public function eventAction()
    {
        $post = $_POST;

        try {
            $attributes = $this->parsePost($post);
        } catch (\Exception $exception) {
            return $this->displayError($exception->getMessage());
        }

        $action = $post['action'];
        unset($post['action']);

        $participants = [];
        if (array_key_exists('participants', $post) && is_array($post['participants'])) {
            $participants = $post['participants'];
            unset($post['participants']);
        }

        switch ($action) {
            case 'add':
                // l'id non mi serve in aggiunta
                unset($attributes['id']);

                $event = CalendarEvent::create($attributes);
                $attributes = $event->attributes();

                $attributes['participants'] = $this->updateParticipants($event, $participants);

                break;

            case 'edit':
                $event = CalendarEvent::find($attributes['id']);

                if ($event === null) {
                    throw new HttpNotFoundException();
                }

                $old_attributes = $event->attributes();
                $event->updateAttributes($attributes);

                $attributes = $event->save() ? $event->attributes() : $old_attributes;

                $attributes['participants'] = $this->updateParticipants($event, $participants);

                break;

            case 'delete':
                $event = CalendarEvent::find($attributes['id']);

                if ($event === null || $event->delete()) {
                    return new JsonResponse(['result' => 'ok']);
                }

                return new JsonResponse(['error' => true, 'message' => 'fail']);

            default:
                throw new HttpNotFoundException('unknown action');
                break;
        }

        // Correggo le date da PonghoDateTime a string e aggiungo i colori
        $attributes['text_color'] = Calendar::$colors[$event->calendar->color]['text'];
        $attributes['bg_color'] = Calendar::$colors[$event->calendar->color]['bg'];
        $attributes['start_date_at'] = $attributes['start_date_at']->format('Y-m-d H:i');
        $attributes['end_date_at'] = $attributes['end_date_at']->format('Y-m-d H:i');

        return new JsonResponse($attributes);
    }

    protected function parsePost(&$post)
    {
        if (isset($post['action'])) {
            /**
             * Se non ho un attributo id, forzo l'aggiunta perché potrei star modificando un evento "virtuale" che deve essere
             * ancora salvato in database
             */
            if (!isset($post['id'])) {
                $post['action'] = 'add';
            }

            /**
             * potrei aver definito un handler per gestire questo evento diversamente dagli altri (solitamente per dare un errore in caso certe condizioni
             * non vengano soddisfatte)
             */
            if (isset($post['handler'])) {
                $post = $post['handler']::parseFields($post);
            }
        } else {
            return new HttpException(400, 'post action not defined!');
        }

        // Forzo l'utente che ha inserito l'evento
        if (!array_key_exists('author_id', $post)) {
            $post['author_id'] = $this->getUser()->id;
        }

        return $this->parseFields($post, CalendarEvent::columns());
    }

    /**
     * Azioni
     */
    public function categoriesAction()
    {
        $id = $_POST['calendar_id'] ?? 0;

        $options = [
            'conditions' => ['calendar_id = :calendar_id', 'calendar_id' => $id],
            'order'      => 'title ASC',
        ];

        $categories = [];
        $code = '<option value="">Scegli una categoria</option>';
        foreach (CalendarCategory::all($options) as $category) {
            $categories[$category->id] = $category->title;
            $code .= '<option value="' . $category->id . '">' . $category->title . '</option>';
        }

        return new JsonResponse($code);
    }

    /**
     *
     */
    public function autocompleteAction()
    {
        $term = $_GET['term'] ?? '';
        $not_in = isset($_GET['not_in']) && is_array($_GET['not_in']) && $_GET['not_in'] ? $_GET['not_in'] : '';
        $filter_roles = isset($_GET['filter_roles']) && is_array($_GET['filter_roles']) && $_GET['filter_roles'] ? $_GET['filter_roles'] : '';

        if ($not_in) {
            $not_in = ' AND id NOT IN(' . implode(',', $not_in) . ')';
        }

        if ($filter_roles) {
            $filter_roles = ' AND role_id IN (' . implode(',', $filter_roles) . ')';
        }

        $options = [
            'conditions' => ['(pongho_like(name, :term) OR pongho_like(surname, :term) OR pongho_like(fullname, :term))' . $not_in . $filter_roles, 'term' => "%{$term}%"],
            'order'      => 'surname ASC, name ASC',
        ];

        $options = $this->filter('calendar.filter_autocomplete_options', $options);

        $users = [];
        foreach (Account::all($options) as $user) {
            $users[] = [
                'id'    => $user->id,
                'label' => $user->name(true),
            ];
        }

        return new JsonResponse($users);
    }

    /**
     *
     */
    public function geteventsAction()
    {
        $start_date = date('Y-m-d H:i:s', $_POST['start']);
        $end_date = date('Y-m-d H:i:s', $_POST['end']);
        $calendars = $_POST['calendars'] ?? [];

        $handler_class = $_POST['handler'] ?? \Application\Calendar\Handler\Data\BaseData::class;
        $filters = $_POST['filters'] ?? [];

        $handler = new $handler_class($this->getUser()->getAccount());
        if ($filters) {
            $handler->setFilters($filters);
        }

        // L'evento potrebbe iniziare prima e finire dopo il giorno corrente
        // prima: 'start_date_at >= :start AND end_date_at < :end'
        $options = [
            'conditions' => ['calendar_id IN (' . implode(', ', array_map('intval', $calendars)) . ') AND start_date_at < :end AND end_date_at > :start', 'start' => $start_date, 'end' => $end_date],
        ];

        return new JsonResponse($handler->getEvents($options, $_POST['start'], $_POST['end'], $calendars));
    }

    /**
     * {@inheritdoc}
     */
    public function getpopupAction()
    {
        if (!isset($_POST['handler'])) {
            throw new HttpNotFoundException('Handler del calendario non impostato');
        }

        $post = $_POST;

        $handler_class = $post['handler'];

        /** @var \Application\Calendar\Handler\DataInterface $handler */
        $handler = new $handler_class($this->getUser());

        //$post['event'] = $this->parsePost($post['event']);
        try {
            $post = $handler_class::parseFields($post);
        } catch (\Exception $exception) {
            return $this->displayError($exception->getMessage());
        }

        $view = $handler->getPopupTemplate($post, $this->getContainer());

        return new TemplateResponse($view);
    }
}
