/**
 * jQuery code for related nodes.
 */

$(document).ready(function () {

	//if (typeof related === 'undefined') {
	//	throw 'Non trovo le opzioni per la gestione dei nodi correlati!';
	//}

	(function ($) {
		var ulist = $("#users-list"),
			utable = $("table", ulist),
			utbody = $("tbody", ulist),
			uclonable = $(".clonable", ulist).hide().clone(),
			search = $("#field-user-search"),
			ucounter = 0,
			cache = [];

		// Cache
		$(".user-row input[type=hidden]", ulist).each(function() {
			var v = $(this).val();
			cache[cache.length] = v;
		});

		// Ricerca
		search.keydown(function (event) {
			if (event.which == 13) {
				event.preventDefault();
			}
		}).autocomplete({
			source: function (request, response) {
				request.not_in = cache;
				$.getJSON(search.data('url'), request, function (data) {
					response(data);
				});
			},
			select: function (event, ui) {
				ucounter++;

				uclonable.clone().each(function () {
					var row = $(this);

					row.removeClass('clonable').addClass('user-row');
					row.find('span.name').text(ui.item.label);
					row.find('.user-id').val(ui.item.id);

					row.find('input').each(function() {
						var field = $(this),
							name = field.attr('name');

						field.attr('name', name.replace(/\[new\]/i, '[new_'+ucounter+']'));
					});
				}).appendTo(utbody).show()

				search.val('');

				//utable.tableZebra(true);

				cache[cache.length] = ui.item.id+'';

				return false;
			}
		});

		// Categorie
		var clist = $('#categories-list'),
			cfield = $('#field-category-name'),
			caddbtn = $('#category-new'),
			ctable = $("table", clist),
			ctbody = $("tbody", clist),
			cclonable = $(".clonable", clist).hide().clone(),
			ccounter = 0;

		caddbtn.on('click', function() {
			ccounter++;

			cclonable.clone().each(function() {
				var row = $(this);

				row.removeClass('clonable').addClass('user-row');
				row.find('.category-title').val(cfield.val());

				row.find('input').each(function() {
					var field = $(this),
						name = field.attr('name');

					field.attr('name', name.replace(/\[new\]/i, '[new_'+ccounter+']'));
				});

				cfield.val('');
			}).appendTo(ctbody).show();
		});

	})(jQuery);

});
