<?php
/**
 * @var $lang \Application\Core\Localization
 * @var $html \Pongho\Template\Html
 *
 * @var $calendar_select  array
 * @var $category_select  array
 * @var $status_select    array
 * @var $autocomplete_url string
 */
?>
	<div id="calendar-popup" class="popupTabs">
		<form class="fINLINE" action="<?php echo $form_action; ?>" method="POST">
			<ul class="tabs">
				<li class="active"><a href="#tab-main"><?php echo $lang->main; ?></a></li>
				<li><a href="#users-list"><?php echo $lang->participants; ?></a></li>
			</ul>

			<div id="calendar-popup-content" class="panel">
				<fieldset id="tab-main" class="tabsPanel active">
					<h3><?php echo $lang->get('main'); ?></h3>
					<div class="wrapfield">
						<label><?php echo $lang->get('calendar'); ?></label>
						<div class="fields"><select name="calendar"><?php echo $html->select($calendar_select, null); ?></select></div>
					</div>

					<div class="wrapfield">
						<label><?php echo $lang->get('title'); ?></label>
						<div class="fields"><input type="text" name="title" class="input_text" /></div>
					</div>

					<div class="wrapfield">
						<label><?php echo $lang->get('description'); ?></label>
						<div class="fields"><textarea name="description"></textarea></div>
					</div>

					<div class="wrapfield">
						<label><?php echo $lang->get('full_day'); ?></label>
						<div class="fields"><input type="checkbox" name="full_day" /></div>
					</div>

					<div class="calendar-popup-datepickers">
						<div class="wrapfield">
							<label><?php echo $lang->get('start'); ?></label>
							<div class="fields"><input type="text" name="start" class="input_text" /></div>
						</div>

						<div class="wrapfield">
							<label><?php echo $lang->get('end'); ?></label>
							<div class="fields"><input type="text" name="end" class="input_text" /></div>
						</div>
					</div>

					<div class="wrapfield">
						<label><?php echo $lang->get('category'); ?></label>
						<div class="fields"><select name="category"><?php echo $html->select($category_select, 0); ?></select></div>
					</div>

					<div class="wrapfield">
						<label><?php echo $lang->get('status'); ?></label>
						<div class="fields"><select name="status"><?php echo $html->select($status_select, 0); ?></select></div>
					</div>
				</fieldset>

				<fieldset id="users-list" class="tabsPanel">
					<h3><?php echo $lang->get('participants'); ?></h3>
					<dl class="extend user-search">
						<dt><label for="field-user-search"><?php echo $lang->get('user_search'); ?></label></dt>
						<dd><input type="text" id="field-user-search" class="input_text" data-url="<?php echo $autocomplete_url; ?>" /></dd>
					</dl>

					<table class="pongho-table">
						<thead>
						<tr>
							<th><?php echo $lang->get('username'); ?></th>
							<th><?php echo $lang->get('delete'); ?></th>
						</tr>
						</thead>
						<tfoot>
						<tr>
							<th><?php echo $lang->get('username'); ?></th>
							<th><?php echo $lang->get('delete'); ?></th>
						</tr>
						</tfoot>
						<tbody>
						<tr class="clonable">
							<td>
								<input type="hidden" name="users[new][user_id]" class="user-id" />
								<span class="name"></span>
							</td>
							<td><span class="icn delete"><?php echo $lang->get('delete'); ?></span></td>
						</tr>
						</tbody>
					</table>
				</fieldset>
			</div>

			<fieldset id="calendar-popup-actions" class="panel">
				<input type="button" data-action="cancel" class="close" value="<?php echo $lang->get('cancel'); ?>" />
				<input type="button" data-action="save" class="save" value="<?php echo $lang->get('save'); ?>" />
				<input type="button" data-action="delete" class="delete" value="<?php echo $lang->get('delete'); ?>" />
			</fieldset>
		</form>
	</div>
