<?php

/**
 * @var Localization       $lang
 *
 * @var string             $action_form
 * @var string             $title
 * @var string             $autocomplete
 *
 * @var string             $field_title
 * @var string             $field_owner_id
 * @var string             $field_color
 * @var string             $field_status
 *
 * @var CalendarCategory[] $calendar_categories
 * @var CalendarUser[]     $calendar_users
 */

use Application\Calendar\Model\CalendarCategory;
use Application\Calendar\Model\CalendarUser;
use Application\Core\Localization;

?>
<form action="<?= $action_form ?>" method="post" class="section">

	<h2><?= $title ?></h2>

	<?php include 'messages.php' ?>

	<fieldset class="panel">
		<h3><?= $lang->get('main'); ?></h3>
		<dl class="extend">
			<dt><label for="title"><?= $lang->get('title'); ?></label></dt>
			<dd><?= $field_title; ?></dd>
		</dl>
		<dl class="extend">
			<dt><label for="owner_id"><?= $lang->get('calendar_owner'); ?></label></dt>
			<dd><?= $field_owner_id; ?></dd>
		</dl>
		<dl class="extend">
			<dt><label for="color"><?= $lang->get('color'); ?></label></dt>
			<dd><?= $field_color; ?></dd>
		</dl>
		<dl class="extend">
			<dt><label for="status"><?= $lang->get('status'); ?></label></dt>
			<dd><?= $field_status; ?></dd>
		</dl>
	</fieldset>

	<fieldset id="categories-list" class="panel">
		<h3><?= $lang->get('categories'); ?></h3>

		<div class="tools">
			<dl class="extend category-name" data-url="<?= $autocomplete; ?>">
				<dt><label for="field-category-name"><?= $lang->get('add_category'); ?></label></dt>
				<dd>
					<input type="text" id="field-category-name" class="input_text">
					<span class="btn" style="float: none; margin-left: 5px;">
						<input type="button" id="category-new" value="<?= $lang->get('add'); ?>">
					</span>
				</dd>
			</dl>
		</div>

		<table class="pongho-table">
			<thead>
				<tr>
					<th><?= $lang->get('title'); ?></th>
					<th><?= $lang->get('delete'); ?></th>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<th><?= $lang->get('title'); ?></th>
					<th><?= $lang->get('delete'); ?></th>
				</tr>
			</tfoot>
			<tbody>
				<?php foreach ( $calendar_categories as $row ): ?>
					<tr class="category-row">
						<td>
							<label>
								<input type="text" name="categories[<?= $row->id; ?>][title]" value="<?= $row->title; ?>" class="input_text">
							</label>
						</td>
						<td>
							<label style="margin-right: 1rem;">
								<input type="checkbox" name="categories[<?= $row->id; ?>][delete]">
								<span>Elimina solo la categoria</span>
							</label>
							<label style="margin-right: 1rem;">
								<input type="checkbox" name="categories[<?= $row->id; ?>][deleteCategoryAndEvents]">
								<span>Elimina categoria ed eventi</span>
							</label>
						</td>
					</tr>
				<?php endforeach; ?>

				<tr class="clonable">
					<td><input type="text" name="categories[new][title]" class="input_text category-title"></td>
					<td><label class="deletable"><input type="checkbox" name="users[new][deletable]"> <span><?= $lang->get('delete'); ?></span></label></td>
				</tr>
			</tbody>
		</table>
	</fieldset>

	<fieldset id="users-list" class="panel">
		<h3><?= $lang->get('sharing'); ?></h3>
		<dl class="extend user-search">
			<dt><label for="field-user-search"><?= $lang->get('search_participant'); ?></label></dt>
			<dd><input type="text" id="field-user-search" class="input_text" data-url="<?= $autocomplete; ?>"></dd>
		</dl>

		<table class="pongho-table">
			<thead>
				<tr>
					<th><?= $lang->get('username'); ?></th>
					<th><?= $lang->get('can_add'); ?></th>
					<th><?= $lang->get('can_edit_self'); ?></th>
					<th><?= $lang->get('can_edit_others'); ?></th>
					<th><?= $lang->get('can_delete_self'); ?></th>
					<th><?= $lang->get('can_delete_others'); ?></th>
					<th><?= $lang->get('can_view_others'); ?></th>
					<th><?= $lang->get('delete'); ?></th>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<th><?= $lang->get('username'); ?></th>
					<th><?= $lang->get('can_add'); ?></th>
					<th><?= $lang->get('can_edit_self'); ?></th>
					<th><?= $lang->get('can_edit_others'); ?></th>
					<th><?= $lang->get('can_delete_self'); ?></th>
					<th><?= $lang->get('can_delete_others'); ?></th>
					<th><?= $lang->get('can_view_others'); ?></th>
					<th><?= $lang->get('delete'); ?></th>
				</tr>
			</tfoot>
			<tbody>
				<?php foreach ( $calendar_users as $row ): ?>
					<tr class="user-row">
						<td>
							<input type="hidden" name="users[<?= $row->user_id; ?>][user_id]" value="<?= $row->user_id; ?>">
							<span class="name"><?= $row->user->name() . ' ' . $row->user->email; ?></span>
						</td>
						<td><input type="checkbox" name="users[<?= $row->user_id; ?>][can_add]"<?= $row->can_add ? ' checked="checked"' : ''; ?>></td>
						<td><input type="checkbox" name="users[<?= $row->user_id; ?>][can_edit_self]"<?= $row->can_edit_self ? ' checked="checked"' : ''; ?>></td>
						<td><input type="checkbox" name="users[<?= $row->user_id; ?>][can_edit_others]"<?= $row->can_edit_others ? ' checked="checked"' : ''; ?>></td>
						<td><input type="checkbox" name="users[<?= $row->user_id; ?>][can_delete_self]"<?= $row->can_delete_self ? ' checked="checked"' : ''; ?>></td>
						<td><input type="checkbox" name="users[<?= $row->user_id; ?>][can_delete_others]"<?= $row->can_delete_others ? ' checked="checked"' : ''; ?>></td>
						<td><input type="checkbox" name="users[<?= $row->user_id; ?>][can_view_others]"<?= $row->can_view_others ? ' checked="checked"' : ''; ?>></td>
						<td><label class="deletable"><input type="checkbox" name="users[<?= $row->user_id; ?>][deletable]"> <span><?= $lang->get('delete'); ?></span></label></td>
					</tr>
				<?php endforeach; ?>

				<tr class="clonable">
					<td>
						<input type="hidden" name="users[new][user_id]" class="user-id">
						<span class="name"></span>
					</td>
					<td><input type="checkbox" name="users[new][can_add]" checked="checked"></td>
					<td><input type="checkbox" name="users[new][can_edit_self]" checked="checked"></td>
					<td><input type="checkbox" name="users[new][can_edit_others]" checked="checked"></td>
					<td><input type="checkbox" name="users[new][can_delete_self]" checked="checked"></td>
					<td><input type="checkbox" name="users[new][can_delete_others]" checked="checked"></td>
					<td><input type="checkbox" name="users[new][can_view_others]" checked="checked"></td>
					<td>
						<label class="deletable">
							<input type="checkbox" name="users[new][deletable]">
							<span><?= $lang->get('delete'); ?></span>
						</label>
					</td>
				</tr>
			</tbody>
		</table>
	</fieldset>

	<fieldset class="btn">
		<input type="submit" name="submit" value="<?= $lang->get('save'); ?>" class="primary">
	</fieldset>

</form><!-- .section -->
